/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.attach.SimpleAttachmentTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.test.OXTestToolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class SaveAsTest
extends InfostoreAJAXTest {
    private final SimpleAttachmentTest attachmentTest = new SimpleAttachmentTest("TaskAttachmentTest");

    public SaveAsTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasic() throws Exception {
        AttachmentMetadata attachment = this.attachmentTest.getAttachment(0);
        String id = this.saveAs(this.getWebConversation(), this.getHostName(), this.sessionId, attachment.getFolderId(), attachment.getAttachedId(), attachment.getModuleId(), attachment.getId(), this.m("folder_id", "" + this.folderId, "title", "My Attachment", "description", "An attachment cum InfoItem"));
        this.clean.add(id);
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        SaveAsTest.assertNotNull((Object)res.getTimestamp());
        JSONObject obj = (JSONObject)res.getData();
        File upload = this.attachmentTest.getTestFile();
        SaveAsTest.assertEquals((String)"My Attachment", (String)obj.getString("title"));
        SaveAsTest.assertEquals((String)"An attachment cum InfoItem", (String)obj.getString("description"));
        SaveAsTest.assertEquals((int)1, (int)obj.getInt("version"));
        SaveAsTest.assertEquals((String)upload.getName(), (String)obj.getString("filename"));
        FileInputStream is = null;
        InputStream is2 = null;
        try {
            is = new FileInputStream(upload);
            is2 = this.document(this.getWebConversation(), this.getHostName(), this.sessionId, id, 1);
            OXTestToolkit.assertSameContent(is, is2);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (is2 != null) {
                is2.close();
            }
        }
    }

    public void testVirtualFolder() throws Exception {
        for (int folderId : virtualFolders) {
            this.virtualFolder(folderId);
        }
    }

    public void virtualFolder(int folderId) throws Exception {
        AttachmentMetadata attachment = this.attachmentTest.getAttachment(0);
        try {
            String id = this.saveAs(this.getWebConversation(), this.getHostName(), this.sessionId, attachment.getFolderId(), attachment.getAttachedId(), attachment.getModuleId(), attachment.getId(), this.m("folder_id", "" + folderId, "title", "My Attachment", "description", "An attachment cum InfoItem"));
            this.clean.add(id);
            SaveAsTest.fail((String)"Expected IOException when trying to save attachment in virtual infostore folder");
        }
        catch (JSONException x) {
            SaveAsTest.assertTrue((String)x.getMessage(), (boolean)x.getMessage().contains("IFO-1700"));
        }
    }

    @Override
    public void setUp() throws Exception {
        this.attachmentTest.setUp();
        this.attachmentTest.upload();
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        this.attachmentTest.tearDown();
        super.tearDown();
    }
}

