/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import java.util.UUID;

public class Bug27474Test
extends ManagedAppointmentTest {
    private static final String ICAL = "BEGIN:VCALENDAR\nPRODID:Open-Xchange\nVERSION:2.0\nCALSCALE:GREGORIAN\nMETHOD:REQUEST\nBEGIN:VEVENT\nDTSTAMP:20130712T082801Z\nSUMMARY:Walk the dog\nDTSTART;TZID=Europe/Berlin:20130708T080000\nDTEND;TZID=Europe/Berlin:20130708T090000\nCLASS:PUBLIC\nTRANSP:OPAQUE\nRRULE:FREQ=DAILY;INTERVAL=1\nUID:${UID}\nCREATED:20130712T082735Z\nLAST-MODIFIED:20130712T082756Z\nORGANIZER:mailto:steffen.templin@premium\nSEQUENCE:1\nATTENDEE;ROLE=REQ-PARTICIPANT;CUTYPE=INDIVIDUAL;CN=Steffen Templin:mailto:steffen.templin@premium\nEND:VEVENT\nBEGIN:VTIMEZONE\nTZID:Europe/Berlin\nTZURL:http://tzurl.org/zoneinfo/Europe/Berlin\nX-LIC-LOCATION:Europe/Berlin\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19810329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19961027T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nBEGIN:STANDARD\nTZOFFSETFROM:+005328\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:18930401T000000\nRDATE:\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19160430T230000\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19161001T010000\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:CEMT\nDTSTART:19450524T020000\nEND:DAYLIGHT\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19450924T030000\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19460101T000000\nEND:STANDARD\nEND:VTIMEZONE\nBEGIN:VEVENT\nDTSTAMP:20130712T082802Z\nSUMMARY:Walk the dog\nDTSTART;TZID=Europe/Berlin:20130709T100000\nDTEND;TZID=Europe/Berlin:20130709T110000\nCLASS:PUBLIC\nTRANSP:OPAQUE\nRECURRENCE-ID:20130709T060000Z\nUID:${UID}\nCREATED:20130712T082756Z\nLAST-MODIFIED:20130712T082756Z\nORGANIZER:mailto:steffen.templin@premium\nSEQUENCE:0\nATTENDEE;ROLE=REQ-PARTICIPANT;CUTYPE=INDIVIDUAL;CN=Steffen Templin:mailto:steffen.templin@premium\nEND:VEVENT\nEND:VCALENDAR";

    public Bug27474Test(String name) {
        super(name);
    }

    public void testRepeatedImportOfASeriesWithChangeException() throws Exception {
        String ical = Bug27474Test.prepareICal();
        ICalImportResponse icalResponse = this.getClient().execute(new ICalImportRequest(this.folder.getObjectID(), ical, false));
        Bug27474Test.assertFalse((String)"Initial import failed", (boolean)icalResponse.hasError());
        Bug27474Test.assertTrue((String)"Should import master and change exception", (icalResponse.getImports().length == 2 ? 1 : 0) != 0);
        icalResponse = this.getClient().execute(new ICalImportRequest(this.folder.getObjectID(), ical, false));
        Bug27474Test.assertTrue((String)"Expected UID conflict", (boolean)icalResponse.hasError());
        Bug27474Test.assertTrue((String)"Should contain only an exception for the master", (icalResponse.getImports().length == 1 ? 1 : 0) != 0);
    }

    private static String prepareICal() {
        return ICAL.replaceAll("\\$\\{UID\\}", UUID.randomUUID().toString());
    }
}

