/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebConversation;
import com.openexchange.ajax.framework.Executor;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class AJAXSession {
    public static final String USER_AGENT = "HTTP API Testing Agent";
    private final WebConversation conversation;
    private final DefaultHttpClient httpClient;
    private String id;

    public AJAXSession() {
        this(AJAXSession.newWebConversation(), AJAXSession.newHttpClient(), null);
    }

    public AJAXSession(WebConversation conversation, String hostname, String id) {
        this(conversation, AJAXSession.newHttpClient(conversation, hostname), id);
    }

    public AJAXSession(WebConversation conversation, DefaultHttpClient httpClient, String id) {
        this.conversation = conversation;
        this.httpClient = httpClient;
        this.id = id;
    }

    public WebConversation getConversation() {
        return this.conversation;
    }

    public DefaultHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static WebConversation newWebConversation() {
        HttpUnitOptions.setDefaultCharacterSet((String)"UTF-8");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        WebConversation retval = new WebConversation();
        retval.getClientProperties().setAcceptGzip(false);
        retval.getClientProperties().setUserAgent(USER_AGENT);
        return retval;
    }

    public static DefaultHttpClient newHttpClient() {
        DefaultHttpClient retval = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());
        HttpParams params = retval.getParams();
        int minute = 60000000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)minute);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)minute);
        retval.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        retval.getParams().setParameter("User-Agent", (Object)USER_AGENT);
        retval.getParams().setParameter("http.useragent", (Object)USER_AGENT);
        return retval;
    }

    public static DefaultHttpClient newHttpClient(WebConversation conversation, String hostname) {
        DefaultHttpClient retval = AJAXSession.newHttpClient();
        Executor.syncCookies(conversation, retval, hostname);
        return retval;
    }
}

