/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.groupware.container.FolderObject;
import java.util.List;

public class UpdateRequest
extends InsertRequest {
    private final FolderObject folder;
    private boolean handDown;
    private Boolean cascade;
    private Boolean ignoreWarnings;

    public UpdateRequest(API api, FolderObject folder, boolean failOnError) {
        super(api, folder, failOnError);
        this.folder = folder;
    }

    public UpdateRequest(API api, FolderObject folder) {
        this(api, folder, true);
    }

    public UpdateRequest setHandDown(boolean handDown) {
        this.handDown = handDown;
        return this;
    }

    public UpdateRequest setCascadePermissions(boolean cascade) {
        this.cascade = cascade;
        return this;
    }

    public UpdateRequest setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
        return this;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "update"));
        if (7 == this.folder.getModule() && this.folder.getFullName() != null) {
            params.add(new AJAXRequest.Parameter("id", this.folder.getFullName()));
        } else {
            params.add(new AJAXRequest.Parameter("id", this.folder.getObjectID()));
            params.add(new AJAXRequest.Parameter("folder", String.valueOf(this.folder.getParentFolderID())));
        }
        params.add(new AJAXRequest.Parameter("timestamp", String.valueOf(this.folder.getLastModified().getTime())));
        if (this.handDown) {
            params.add(new AJAXRequest.Parameter("permissions", "inherit"));
        }
        if (this.cascade != null) {
            params.add(new AJAXRequest.Parameter("cascadePermissions", this.cascade));
        }
        if (this.ignoreWarnings != null) {
            params.add(new AJAXRequest.Parameter("ignoreWarnings", this.ignoreWarnings));
        }
    }
}

