/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.folder.actions.GenJSONParser;
import com.openexchange.ajax.folder.actions.GenJSONResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.json.JSONValue;

public class GenJSONRequest
extends AbstractFolderRequest<GenJSONResponse> {
    private final boolean failOnError;
    private JSONValue jsonValue;
    private AJAXRequest.Method method;
    private final Map<String, String> parameters;

    public GenJSONRequest(API api) {
        this(api, true);
    }

    public GenJSONRequest(API api, boolean failOnError) {
        super(api);
        this.failOnError = failOnError;
        this.method = AJAXRequest.Method.PUT;
        this.parameters = new HashMap<String, String>();
    }

    public void setJSONValue(JSONValue jsonValue) {
        this.jsonValue = jsonValue;
    }

    public void setMethod(AJAXRequest.Method method) {
        this.method = method;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    public Object getBody() {
        return null == this.jsonValue ? JSONObject.NULL : this.jsonValue;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return this.method;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            params.add(new AJAXRequest.Parameter(entry.getKey(), entry.getValue()));
        }
    }

    public GenJSONParser getParser() {
        return new GenJSONParser(this.failOnError);
    }
}

