/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequestNew;
import com.openexchange.ajax.folder.actions.GetResponseNew;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.exception.OXException;
import com.openexchange.folder.json.services.ServiceRegistry;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.internal.ContentTypeRegistry;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.FolderTestManager;
import java.io.IOException;
import java.util.UUID;
import org.json.JSONException;
import org.junit.Before;

public abstract class AbstractObjectCountTest
extends AbstractAJAXSession {
    protected static final int[] DEFAULT_COLUMNS = new int[]{1, 2, 3, 4, 5, 6, 20, 300, 301, 302, 309};
    protected AJAXClient client1;
    protected AJAXClient client2;

    protected AbstractObjectCountTest(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        ContentTypeRegistry ctr = ContentTypeRegistry.getInstance();
        ServiceRegistry.getInstance().addService(ContentTypeRegistry.class, (Object)ctr);
    }

    protected static Folder getFolder(AJAXClient client, int folderId, int[] columns) throws OXException, IOException, JSONException {
        GetRequestNew req = new GetRequestNew(EnumAPI.OX_NEW, String.valueOf(folderId), columns);
        GetResponseNew resp = client.execute(req);
        return resp.getFolder();
    }

    protected static FolderObject createPrivateFolder(AJAXClient client, FolderTestManager ftm, int module) throws OXException, IOException, JSONException {
        FolderObject folder = ftm.generatePrivateFolder(UUID.randomUUID().toString(), module, AbstractObjectCountTest.getParentFolderForModule(client, module), client.getValues().getUserId());
        return ftm.insertFolderOnServer(folder);
    }

    protected static FolderObject createSharedFolder(AJAXClient client, int module, int userId2, FolderTestManager ftm) throws OXException, IOException, JSONException {
        FolderObject folder = ftm.generateSharedFolder(UUID.randomUUID().toString(), module, AbstractObjectCountTest.getParentFolderForModule(client, module), client.getValues().getUserId());
        OCLPermission permissions = new OCLPermission();
        permissions.setEntity(userId2);
        permissions.setGroupPermission(false);
        permissions.setFolderAdmin(false);
        permissions.setAllPermission(4, 4, 4, 4);
        folder.addPermission(permissions);
        return ftm.insertFolderOnServer(folder);
    }

    protected static FolderObject createSharedFolder(AJAXClient client, int module, FolderTestManager ftm, OCLPermission ... permissions) throws OXException, IOException, JSONException {
        FolderObject folder = ftm.generateSharedFolder(UUID.randomUUID().toString(), module, AbstractObjectCountTest.getParentFolderForModule(client, module), client.getValues().getUserId());
        folder.removePermissions();
        for (OCLPermission permission : permissions) {
            folder.addPermission(permission);
        }
        return ftm.insertFolderOnServer(folder);
    }

    protected static FolderObject createPublicFolder(AJAXClient client, int module, int userId2, FolderTestManager ftm) throws OXException, IOException, JSONException {
        FolderObject folder = ftm.generatePublicFolder(UUID.randomUUID().toString(), module, 2, client.getValues().getUserId());
        OCLPermission permissions = new OCLPermission();
        permissions.setEntity(userId2);
        permissions.setGroupPermission(false);
        permissions.setFolderAdmin(false);
        permissions.setAllPermission(4, 2, 4, 4);
        folder.addPermission(permissions);
        return ftm.insertFolderOnServer(folder);
    }

    protected static int getParentFolderForModule(AJAXClient client, int module) throws OXException, IOException, JSONException {
        switch (module) {
            case 2: {
                return client.getValues().getPrivateAppointmentFolder();
            }
            case 1: {
                return client.getValues().getPrivateTaskFolder();
            }
            case 8: {
                return client.getValues().getPrivateInfostoreFolder();
            }
            case 3: {
                return client.getValues().getPrivateContactFolder();
            }
        }
        return -1;
    }
}

