/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.TimeZone;

public final class Bug12280Test
extends AbstractAJAXSession {
    private TimeZone tz;
    private int folderId;
    private Appointment appointment;

    public Bug12280Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        AJAXClient client = this.getClient();
        this.tz = client.getValues().getTimeZone();
        this.folderId = client.getValues().getPrivateAppointmentFolder();
        this.appointment = this.createAppointment();
        InsertRequest request = new InsertRequest(this.appointment, this.tz);
        AppointmentInsertResponse response = client.execute(request);
        response.fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest request = new DeleteRequest(this.appointment);
        this.getClient().execute(request);
        super.tearDown();
    }

    public void testDailyFullTimeUntil() throws Throwable {
        AJAXClient client = this.getClient();
        GetRequest request = new GetRequest(this.appointment);
        GetResponse response = client.execute(request);
        response.getAppointment(this.tz);
    }

    private final Appointment createAppointment() {
        Calendar calendar = TimeTools.createCalendar(TimeZone.getTimeZone("UTC"));
        Appointment appointment = new Appointment();
        appointment.setTitle("test for bug 12280");
        appointment.setParentFolderID(this.folderId);
        calendar.set(11, 0);
        appointment.setStartDate(calendar.getTime());
        calendar.add(5, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.setFullTime(true);
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setOccurrence(3);
        return appointment;
    }
}

