/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.FolderTestManager;

public class FolderIdTestAjax
extends AbstractAJAXSession {
    private Appointment appointment;
    private CalendarTestManager ctm;
    private AJAXClient client2;
    private FolderTestManager ftm;
    private FolderObject folderA;
    private FolderObject folderB;

    public FolderIdTestAjax(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ftm = new FolderTestManager(this.client);
        this.ctm = new CalendarTestManager(this.client);
        this.folderA = this.ftm.generateSharedFolder("folder A" + System.currentTimeMillis(), Module.CALENDAR.getFolderConstant(), this.client.getValues().getPrivateAppointmentFolder(), this.client.getValues().getUserId(), this.client2.getValues().getUserId());
        this.ftm.insertFolderOnServer(this.folderA);
        this.folderB = this.ftm.generateSharedFolder("folder B" + System.currentTimeMillis(), Module.CALENDAR.getFolderConstant(), this.client.getValues().getPrivateAppointmentFolder(), this.client.getValues().getUserId(), this.client2.getValues().getUserId());
        this.ftm.insertFolderOnServer(this.folderB);
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.folderA.getObjectID());
        this.appointment.setTitle("Folder Id");
        this.appointment.setStartDate(TimeTools.D("26.12.2013 08:00"));
        this.appointment.setEndDate(TimeTools.D("27.12.2013 09:00"));
        this.appointment.setIgnoreConflicts(true);
        this.ctm.insert(this.appointment);
    }

    public void testSomething() throws Exception {
        this.ctm.setClient(this.client2);
        this.appointment.setParentFolderID(this.folderB.getObjectID());
        this.ctm.update(this.appointment);
        Appointment loaded = this.ctm.get(this.folderB.getObjectID(), this.appointment.getObjectID());
        System.out.println(loaded.getTitle());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        this.ftm.cleanUp();
        super.tearDown();
    }
}

