/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.FolderTestManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Bug26350Test
extends AbstractAJAXSession {
    private AJAXClient client1;
    private CalendarTestManager ctm1;
    private final int cycles = 3;
    private final int chunkSize = 20;
    private List<List<Integer>> ids;
    private FolderTestManager ftm;
    private FolderObject folder;

    public Bug26350Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ids = new ArrayList<List<Integer>>();
        this.client1 = new AJAXClient(AJAXClient.User.User1);
        this.ctm1 = new CalendarTestManager(this.client1);
        this.ctm1.setFailOnError(true);
        this.ftm = new FolderTestManager(this.client1);
        this.folder = this.ftm.generatePrivateFolder("Bug26350 Folder" + System.currentTimeMillis(), 2, this.client1.getValues().getPrivateAppointmentFolder(), this.client1.getValues().getUserId());
        this.ftm.insertFolderOnServer(this.folder);
    }

    public void testBug26350() throws Exception {
        for (int i = 0; i < 3; ++i) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int j = 0; j < 20; ++j) {
                Appointment app = new Appointment();
                app.setTitle("Bug 26350 Test " + System.currentTimeMillis());
                app.setStartDate(TimeTools.D("13.06.2013 08:00"));
                app.setEndDate(TimeTools.D("13.06.2013 09:00"));
                app.setParentFolderID(this.folder.getObjectID());
                app.setIgnoreConflicts(true);
                Appointment insert = this.ctm1.insert(app);
                arrayList.add(insert.getObjectID());
            }
            this.ids.add(arrayList);
        }
        for (List<Integer> list : this.ids) {
            DeleteRequest[] requests = new DeleteRequest[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                requests[j] = new DeleteRequest(list.get(j), this.folder.getObjectID(), new Date(Long.MAX_VALUE));
            }
            MultipleResponse response = (MultipleResponse)this.client1.execute(MultipleRequest.create(requests));
            for (CommonDeleteResponse deleteResponse : response) {
                Bug26350Test.assertFalse((String)"Delete Response should not have an error.", (boolean)deleteResponse.hasError());
            }
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm1.cleanUp();
        this.ftm.cleanUp();
        this.client1.logout();
        super.tearDown();
    }
}

