/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import java.util.Date;

public class Bug13090Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private FolderObject folder;
    private Appointment exception;
    private Appointment updateAppointment;

    public Bug13090Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folder = Create.folder(1, "Bug 13090 Folder " + System.currentTimeMillis(), 2, 1, Create.ocl(this.getClient().getValues().getUserId(), false, true, 128, 128, 128, 128));
        CommonInsertResponse response = this.getClient().execute(new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_OLD, this.folder));
        response.fillObject((DataObject)this.folder);
        this.appointment = new Appointment();
        this.appointment.setStartDate(TimeTools.D("11.04.2011 08:00"));
        this.appointment.setEndDate(TimeTools.D("11.04.2011 09:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(3);
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setTitle("Bug 13090 Test");
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.getClient().execute(insertRequest);
        insertResponse.fillAppointment(this.appointment);
        this.exception = new Appointment();
        this.exception.setObjectID(this.appointment.getObjectID());
        this.exception.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.exception.setStartDate(TimeTools.D("12.04.2011 09:00"));
        this.exception.setEndDate(TimeTools.D("12.04.2011 10:00"));
        this.exception.setRecurrenceType(0);
        this.exception.setIgnoreConflicts(true);
        this.exception.setLastModified(new Date(Long.MAX_VALUE));
        this.exception.setRecurrencePosition(2);
        UpdateRequest updateRequest = new UpdateRequest(this.exception, this.getClient().getValues().getTimeZone());
        this.getClient().execute(updateRequest);
        this.updateAppointment = new Appointment();
        this.updateAppointment.setObjectID(this.appointment.getObjectID());
        this.updateAppointment.setParentFolderID(this.folder.getObjectID());
        this.updateAppointment.setIgnoreConflicts(true);
        this.updateAppointment.setLastModified(new Date(Long.MAX_VALUE));
    }

    public void testErrorMessag() throws Exception {
        UpdateRequest updateRequest = new UpdateRequest(this.getClient().getValues().getPrivateAppointmentFolder(), this.updateAppointment, this.getClient().getValues().getTimeZone(), false);
        UpdateResponse updateResponse = this.getClient().execute(updateRequest);
        if (updateResponse.hasError()) {
            Bug13090Test.assertTrue((String)"Wrong exception code.", (boolean)updateResponse.getException().similarTo(OXCalendarExceptionCodes.RECURRING_FOLDER_MOVE.create()));
        } else {
            Bug13090Test.fail((String)"Error expected.");
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest((API)EnumAPI.OX_OLD, this.folder));
        this.appointment.setLastModified(new Date(Long.MAX_VALUE));
        this.getClient().execute(new com.openexchange.ajax.appointment.action.DeleteRequest(this.appointment));
        super.tearDown();
    }
}

