/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.cookies.CookieJar;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.LoginServlet;
import com.openexchange.tools.URLParameter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import javax.activation.MimetypesFileTypeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public final class AJAXFileUploadTest
extends AbstractAJAXTest {
    private static final String URL = "/ajax/file";
    private static final String FILE_CONTENT = "A hash table supporting full concurrency of retrievals and adjustable expected concurrency for updates.\nThis class obeys the same functional specification as Hashtable, and includes versions of methods corresponding to each method of Hashtable.\nHowever, even though all operations are thread-safe, retrieval operations do not entail locking, and there is not any support for locking the entire table in a way that prevents all access.\nThis class is fully interoperable with Hashtable in programs that rely on its thread safety but not on its synchronization details.\n\nRetrieval operations (including get) generally do not block, so may overlap with update operations (including put and remove).\nRetrievals reflect the results of the most recently completed update operations holding upon their onset.\nFor aggregate operations such as putAll and clear, concurrent retrievals may reflect insertion or removal of only some entries.\nSimilarly, Iterators and Enumerations return elements reflecting the state of the hash table at some point at or since the creation of the iterator/enumeration.\nThey do not throw ConcurrentModificationException. However, iterators are designed to be used by only one thread at a time.";
    private String sessionId;

    public AJAXFileUploadTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.sessionId = this.getSessionId();
    }

    @Override
    public void tearDown() throws Exception {
        this.logout();
    }

    private static final String getUploadedFile(WebConversation conversation, String hostname, String sessionId, String id) throws IOException, SAXException {
        GetMethodWebRequest getRequest = new GetMethodWebRequest(hostname + URL);
        getRequest.setParameter("session", sessionId);
        getRequest.setParameter("action", "get");
        getRequest.setParameter("id", id);
        WebResponse resp = conversation.getResponse((WebRequest)getRequest);
        return resp.getText();
    }

    private static final JSONObject uploadFiles(WebConversation conversation, String hostname, String sessionId, File[] files, String module, String fileFilter, boolean setCookie) throws IOException, JSONException {
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", sessionId);
        parameter.setParameter("action", "new");
        parameter.setParameter("module", module);
        parameter.setParameter("type", fileFilter);
        PostMethodWebRequest req = null;
        WebResponse resp = null;
        if (setCookie) {
            CookieJar cookieJar = new CookieJar();
            cookieJar.putCookie(LoginServlet.SESSION_PREFIX + sessionId, sessionId);
        }
        PostMethodWebRequest postReq = new PostMethodWebRequest(hostname + URL + parameter.getURLParameters(), true);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            postReq.selectFile("file_" + i, f, AJAXFileUploadTest.getFileContentType(f));
        }
        req = postReq;
        resp = conversation.getResource((WebRequest)req);
        if (resp.getResponseCode() >= 300) {
            throw new Error("Error Status Code " + resp.getResponseCode() + ": " + resp.getResponseMessage());
        }
        JSONObject jResponse = AJAXFileUploadTest.extractFromCallback(resp.getText());
        return jResponse;
    }

    private static final String getFileContentType(File f) {
        return new MimetypesFileTypeMap().getContentType(f);
    }

    private static final File createTempFile() {
        try {
            File tmpFile = File.createTempFile("file_", ".txt");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tmpFile)));
            BufferedReader reader = new BufferedReader(new StringReader(FILE_CONTENT));
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line + "\r\n");
            }
            reader.close();
            writer.flush();
            writer.close();
            tmpFile.deleteOnExit();
            return tmpFile;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void testUploadFile() {
        try {
            File[] fa = new File[]{AJAXFileUploadTest.createTempFile(), AJAXFileUploadTest.createTempFile(), AJAXFileUploadTest.createTempFile()};
            JSONObject jResp = AJAXFileUploadTest.uploadFiles(this.getWebConversation(), "http://" + this.getHostName(), this.sessionId, fa, "mail", "file", false);
            AJAXFileUploadTest.assertTrue((String)"JSON response is either null or has key \"error\"!", (jResp != null && !jResp.has("error") ? 1 : 0) != 0);
            AJAXFileUploadTest.assertTrue((String)"JSON response has no key \"data\"", (boolean)jResp.has("data"));
            JSONArray jArray = jResp.getJSONArray("data");
            AJAXFileUploadTest.assertTrue((String)("Number of received IDs is " + jArray.length() + " but should be 3"), (jArray.length() == 3 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            AJAXFileUploadTest.fail((String)e.getMessage());
        }
        catch (JSONException e) {
            e.printStackTrace();
            AJAXFileUploadTest.fail((String)e.getMessage());
        }
    }

    public void testGetUploadedFile() {
        try {
            File[] fa = new File[]{AJAXFileUploadTest.createTempFile()};
            JSONObject jResp = AJAXFileUploadTest.uploadFiles(this.getWebConversation(), "http://" + this.getHostName(), this.sessionId, fa, "mail", "file", false);
            AJAXFileUploadTest.assertTrue((String)"JSON response is either null or has key \"error\"!", (jResp != null && !jResp.has("error") ? 1 : 0) != 0);
            AJAXFileUploadTest.assertTrue((String)"JSON response has no key \"data\"", (boolean)jResp.has("data"));
            JSONArray jArray = jResp.getJSONArray("data");
            AJAXFileUploadTest.assertTrue((String)("Number of received IDs is " + jArray.length() + " but should be 1"), (jArray.length() == 1 ? 1 : 0) != 0);
            String id = jArray.getString(0);
            String content = AJAXFileUploadTest.getUploadedFile(this.getWebConversation(), "http://" + this.getHostName(), this.sessionId, id);
            AJAXFileUploadTest.assertTrue((String)"File content was not present!", (content != null && content.length() > 0 ? 1 : 0) != 0);
            AJAXFileUploadTest.assertTrue((String)"File content is not equal to expected one", (boolean)FILE_CONTENT.replaceAll("\r?\n", "").equalsIgnoreCase(content.replaceAll("\r?\n", "")));
        }
        catch (IOException e) {
            e.printStackTrace();
            AJAXFileUploadTest.fail((String)e.getMessage());
        }
        catch (JSONException e) {
            e.printStackTrace();
            AJAXFileUploadTest.fail((String)e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            AJAXFileUploadTest.fail((String)e.getMessage());
        }
    }
}

