/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.pop3.POP3Store;
import com.sun.mail.pop3.Protocol;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.mail.MessagingException;

public final class POP3Prober {
    private final Protocol protocol;
    private final List<Exception> warnings;
    private final int total;

    public POP3Prober(POP3Store pop3Store, POP3Folder pop3Folder) throws MessagingException {
        this.total = pop3Folder.getMessageCount();
        this.protocol = 0 == this.total ? null : pop3Folder.getProtocol();
        this.warnings = new ArrayList<Exception>(2);
    }

    public String[] getUIDLs() {
        try {
            String[] uids = new String[this.total];
            if (!this.protocol.uidl(uids)) {
                return null;
            }
            return uids;
        }
        catch (IOException e) {
            this.warnings.add(e);
            return null;
        }
    }

    public boolean probeUIDL() {
        if (null == this.protocol) {
            return true;
        }
        try {
            return this.protocol.uidl(new String[1]);
        }
        catch (IOException e) {
            this.warnings.add(e);
            return false;
        }
    }

    public boolean probeTOP() {
        if (null == this.protocol) {
            return true;
        }
        try {
            return null != this.protocol.top(1, 1);
        }
        catch (IOException e) {
            this.warnings.add(e);
            return false;
        }
    }

    public List<Exception> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }
}

