/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.anonymizer;

import com.openexchange.ajax.anonymizer.AnonymizerService;
import com.openexchange.ajax.anonymizer.Anonymizers;
import com.openexchange.ajax.anonymizer.Module;
import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.tools.mappings.json.JsonMapping;
import com.openexchange.session.Session;
import com.openexchange.share.ShareService;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.user.json.osgi.Services;
import java.util.Set;

public class ContactAnonymizerService
implements AnonymizerService<Contact> {
    private static final ContactField[] WHITELIST_FIELDS = new ContactField[]{ContactField.INTERNAL_USERID, ContactField.OBJECT_ID, ContactField.FOLDER_ID, ContactField.UID, ContactField.CREATED_BY, ContactField.CREATION_DATE, ContactField.MODIFIED_BY, ContactField.LAST_MODIFIED, ContactField.LAST_MODIFIED_OF_NEWEST_ATTACHMENT, ContactField.LAST_MODIFIED_UTC};

    public Module getModule() {
        return Module.CONTACT;
    }

    public Contact anonymize(Contact entity, Session session) throws OXException {
        if (null == entity) {
            return null;
        }
        if (session.getUserId() == entity.getInternalUserId()) {
            return entity;
        }
        if (entity.getInternalUserId() > 0) {
            Set userIds;
            if (entity.getInternalUserId() == ServerSessionAdapter.valueOf((Session)session).getUser().getCreatedBy()) {
                return entity;
            }
            ShareService shareService = Services.getService(ShareService.class);
            if (null != shareService && (userIds = shareService.getSharingUsersFor(session.getContextId(), session.getUserId())).contains(entity.getInternalUserId())) {
                return entity;
            }
        }
        Contact anonymizedContact = new Contact();
        ContactMapper instance = ContactMapper.getInstance();
        for (ContactField contactField : WHITELIST_FIELDS) {
            try {
                JsonMapping mapping = instance.get((Enum)contactField);
                mapping.copy((Object)entity, (Object)anonymizedContact);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int userId = entity.getInternalUserId();
        String i18n = Anonymizers.getUserI18nFor((Session)session);
        anonymizedContact.setDisplayName(i18n + ' ' + userId);
        anonymizedContact.setGivenName(Integer.toString(userId));
        anonymizedContact.setSurName(i18n);
        return anonymizedContact;
    }
}

