/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.contact.ContactService;
import com.openexchange.contact.SortOptions;
import com.openexchange.contact.SortOrder;
import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.Type;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.user.json.UserContact;
import com.openexchange.user.json.actions.AbstractUserAction;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.filter.UserCensorship;
import com.openexchange.user.json.mapping.UserMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="search", description="Search users.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="columns", description="The requested fields."), @Parameter(name="sort", optional=true, type=Type.NUMBER, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified. In case of use of column 609 (use count depending order for collected users with global address book) the parameter \"order\" ist NOT necessary and will be ignored."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, requestBody="An Object as described in Search users. Alternative request body: An Object as described in Search users alternative.", responseDescription="An array with user data. Each array element describes one user and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class SearchAction
extends AbstractUserAction {
    public static final String ACTION = "search";

    public SearchAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        UserField orderByUserField;
        ContactField sortField;
        int[] columns = SearchAction.parseIntArrayParameter("columns", request);
        int orderBy = SearchAction.parseIntParameter("sort", request);
        Order order = OrderFields.parse((String)request.getParameter("order"));
        String collation = request.getParameter("collation");
        JSONObject jData = (JSONObject)request.requireData();
        ContactSearchObject contactSearch = new ContactSearchObject();
        contactSearch.addFolder(6);
        try {
            if (jData.has("pattern")) {
                contactSearch.setPattern(SearchAction.parseString(jData, "pattern"));
            }
            if (jData.has("startletter")) {
                contactSearch.setStartLetter(SearchAction.parseBoolean(jData, "startletter"));
            }
            if (jData.has("emailAutoComplete") && jData.getBoolean("emailAutoComplete")) {
                contactSearch.setEmailAutoComplete(true);
            }
            if (jData.has("orSearch") && jData.getBoolean("orSearch")) {
                contactSearch.setOrSearch(true);
            }
            contactSearch.setSurname(SearchAction.parseString(jData, "last_name"));
            contactSearch.setDisplayName(SearchAction.parseString(jData, "display_name"));
            contactSearch.setGivenName(SearchAction.parseString(jData, "first_name"));
            contactSearch.setCompany(SearchAction.parseString(jData, "company"));
            contactSearch.setEmail1(SearchAction.parseString(jData, "email1"));
            contactSearch.setEmail2(SearchAction.parseString(jData, "email2"));
            contactSearch.setEmail3(SearchAction.parseString(jData, "email3"));
            contactSearch.setDynamicSearchField(SearchAction.parseJSONIntArray(jData, "dynamicsearchfield"));
            contactSearch.setDynamicSearchFieldValue(SearchAction.parseJSONStringArray(jData, "dynamicsearchfieldvalue"));
            contactSearch.setPrivatePostalCodeRange(SearchAction.parseJSONStringArray(jData, "privatepostalcoderange"));
            contactSearch.setBusinessPostalCodeRange(SearchAction.parseJSONStringArray(jData, "businesspostalcoderange"));
            contactSearch.setPrivatePostalCodeRange(SearchAction.parseJSONStringArray(jData, "privatepostalcoderange"));
            contactSearch.setOtherPostalCodeRange(SearchAction.parseJSONStringArray(jData, "otherpostalcoderange"));
            contactSearch.setBirthdayRange(SearchAction.parseJSONDateArray(jData, "birthdayrange"));
            contactSearch.setAnniversaryRange(SearchAction.parseJSONDateArray(jData, "anniversaryrange"));
            contactSearch.setNumberOfEmployeesRange(SearchAction.parseJSONStringArray(jData, "numberofemployee"));
            contactSearch.setSalesVolumeRange(SearchAction.parseJSONStringArray(jData, "salesvolumerange"));
            contactSearch.setCreationDateRange(SearchAction.parseJSONDateArray(jData, "creationdaterange"));
            contactSearch.setLastModifiedRange(SearchAction.parseJSONDateArray(jData, "lastmodifiedrange"));
            contactSearch.setCatgories(SearchAction.parseString(jData, "categories"));
            contactSearch.setSubfolderSearch(SearchAction.parseBoolean(jData, "subfoldersearch"));
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        UserField orderField = (UserField)UserMapper.getInstance().getMappedField(orderBy);
        SortOptions sortOptions = new SortOptions(collation);
        if (null == orderField && null != (sortField = (ContactField)ContactMapper.getInstance().getMappedField(orderBy))) {
            sortOptions.setOrderBy(new SortOrder[]{SortOptions.Order((ContactField)sortField, (Order)order)});
        }
        Date lastModified = new Date(0L);
        ArrayList<UserContact> userContacts = new ArrayList<UserContact>();
        ContactService contactService = (ContactService)this.services.getService(ContactService.class);
        ContactField[] contactFields = (ContactField[])ContactMapper.getInstance().getFields(columns, (Enum[])new ContactField[]{ContactField.INTERNAL_USERID, ContactField.LAST_MODIFIED});
        UserService userService = (UserService)this.services.getService(UserService.class);
        UserField[] userFields = (UserField[])UserMapper.getInstance().getFields(columns);
        boolean needsUserData = null != userFields && 0 < userFields.length;
        UserCensorship censorship = needsUserData ? SearchAction.getUserCensorship(session) : null;
        SearchIterator searchIterator = null;
        try {
            searchIterator = contactService.searchUsers((Session)session, contactSearch, contactFields, sortOptions);
            while (searchIterator.hasNext()) {
                UserImpl user;
                Contact contact = (Contact)searchIterator.next();
                if (contact.getLastModified().after(lastModified)) {
                    lastModified = contact.getLastModified();
                }
                if (needsUserData && 0 < contact.getInternalUserId()) {
                    user = userService.getUser(contact.getInternalUserId(), session.getContext());
                    if (null != censorship && session.getUserId() != user.getId()) {
                        user = censorship.censor((User)user);
                    }
                } else {
                    UserImpl placeholder = new UserImpl();
                    placeholder.setId(contact.getInternalUserId());
                    user = placeholder;
                }
                userContacts.add(new UserContact(contact, (User)user));
            }
        }
        finally {
            if (null != searchIterator) {
                searchIterator.close();
            }
        }
        if (1 < userContacts.size() && null != (orderByUserField = (UserField)UserMapper.getInstance().getMappedField(orderBy))) {
            Collections.sort(userContacts, UserContact.getComparator(orderByUserField, session.getUser().getLocale(), Order.DESCENDING.equals((Object)order)));
        }
        return new AJAXRequestResult(userContacts, lastModified, "usercontact");
    }

    private static String parseString(JSONObject jsonObj, String name) throws JSONException {
        String test;
        String retval = null;
        if (jsonObj.hasAndNotNull(name) && 0 != (test = jsonObj.getString(name)).length()) {
            retval = test;
        }
        return retval;
    }

    private static boolean parseBoolean(JSONObject jsonObj, String name) throws JSONException {
        if (!jsonObj.has(name)) {
            return false;
        }
        return jsonObj.getBoolean(name);
    }

    private static int[] parseJSONIntArray(JSONObject jsonObj, String name) throws JSONException, OXException {
        if (!jsonObj.has(name)) {
            return null;
        }
        JSONArray tmp = jsonObj.getJSONArray(name);
        if (tmp == null) {
            return null;
        }
        try {
            int[] i = new int[tmp.length()];
            for (int a = 0; a < tmp.length(); ++a) {
                i[a] = tmp.getInt(a);
            }
            return i;
        }
        catch (NumberFormatException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create((Throwable)exc, new Object[]{name, tmp});
        }
    }

    private static String[] parseJSONStringArray(JSONObject jsonObj, String name) throws JSONException {
        if (!jsonObj.hasAndNotNull(name)) {
            return null;
        }
        JSONArray tmp = jsonObj.getJSONArray(name);
        String[] s = new String[tmp.length()];
        for (int a = 0; a < tmp.length(); ++a) {
            s[a] = tmp.getString(a);
        }
        return s;
    }

    private static Date[] parseJSONDateArray(JSONObject jsonObj, String name) throws JSONException, OXException {
        if (!jsonObj.has(name)) {
            return null;
        }
        JSONArray tmp = jsonObj.getJSONArray(name);
        if (tmp == null) {
            return null;
        }
        try {
            Date[] d = new Date[tmp.length()];
            for (int a = 0; a < tmp.length(); ++a) {
                d[a] = new Date(tmp.getLong(a));
            }
            return d;
        }
        catch (NumberFormatException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create((Throwable)exc, new Object[]{name, tmp});
        }
    }
}

