/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.share.notification;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Entities {
    private final Map<Integer, Permission> users = new LinkedHashMap<Integer, Permission>();
    private final Map<Integer, Permission> groups = new LinkedHashMap<Integer, Permission>();

    public void addUser(int userId, PermissionType type, int permissions) {
        this.users.put(userId, new Permission(type, permissions));
    }

    public void addGroup(int groupId, PermissionType type, int permissions) {
        this.groups.put(groupId, new Permission(type, permissions));
    }

    public Set<Integer> getUsers() {
        return this.users.keySet();
    }

    public Set<Integer> getGroups() {
        return this.groups.keySet();
    }

    public Permission getUserPermissionBits(int userId) {
        return this.users.get(userId);
    }

    public Permission getGroupPermissionBits(int groupId) {
        return this.groups.get(groupId);
    }

    public int size() {
        return this.users.size() + this.groups.size();
    }

    public static final class Permission {
        private final PermissionType type;
        private final int permissions;

        public Permission(PermissionType type, int permissions) {
            this.type = type;
            this.permissions = permissions;
        }

        public PermissionType getType() {
            return this.type;
        }

        public int getPermissions() {
            return this.permissions;
        }
    }

    public static enum PermissionType {
        FOLDER,
        OBJECT;

    }
}

