/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.util;

import com.openexchange.tools.TimeZoneUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, d MMM yyyy kk:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'", Locale.US)};
    private static final SimpleDateFormat output_format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date convert(String s) {
        if (s == null) {
            return null;
        }
        Date date = null;
        for (int i = 0; date == null && i < formats.length; ++i) {
            try {
                SimpleDateFormat simpleDateFormat = formats[i];
                synchronized (simpleDateFormat) {
                    date = formats[i].parse(s);
                    continue;
                }
            }
            catch (ParseException e) {
                LOG.debug("", (Throwable)e);
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(Date d) {
        if (d == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = output_format;
        synchronized (simpleDateFormat) {
            return output_format.format(d);
        }
    }

    public static String getStatusString(int s) {
        switch (s) {
            case 200: {
                return "OK";
            }
            case 404: {
                return "NOT FOUND";
            }
            case 403: {
                return "FORBIDDEN";
            }
            case 409: {
                return "CONFLICT";
            }
        }
        return "Unknown";
    }

    static {
        output_format.setTimeZone(TimeZoneUtils.getTimeZone("UTC"));
    }
}

