/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.login.Interface;
import com.openexchange.monitoring.MonitoringInfo;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.webdav.LastModifiedCache;
import com.openexchange.webdav.PendingInvocations;
import com.openexchange.webdav.QueuedAction;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.AppointmentParser;
import com.openexchange.webdav.xml.AppointmentWriter;
import com.openexchange.webdav.xml.XmlServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class calendar
extends XmlServlet<AppointmentSQLInterface> {
    private static final long serialVersionUID = 5779820324953825111L;
    static final Logger LOG = LoggerFactory.getLogger(calendar.class);

    @Override
    protected Interface getInterface() {
        return Interface.WEBDAV_XML;
    }

    @Override
    protected boolean isServletDisabled() {
        return true;
    }

    @Override
    protected void parsePropChilds(HttpServletRequest req, HttpServletResponse resp, XmlPullParser parser, PendingInvocations<AppointmentSQLInterface> pendingInvocations) throws XmlPullParserException, IOException, OXException {
        Session session = calendar.getSession(req);
        if (this.isTag(parser, "prop", "DAV:")) {
            parser.nextTag();
            Context ctx = ContextStorage.getInstance().getContext(session.getContextId());
            CalendarDataObject appointmentobject = new CalendarDataObject();
            AppointmentParser ap = new AppointmentParser(session);
            ap.parse(parser, appointmentobject);
            int method = ap.getMethod();
            appointmentobject.setContext(ctx);
            Date lastModified = appointmentobject.getLastModified();
            appointmentobject.removeLastModified();
            int inFolder = ap.getFolder();
            switch (method) {
                case 1: {
                    if (appointmentobject.containsObjectID()) {
                        this.sanitize(appointmentobject);
                        pendingInvocations.add(new QueuedAppointment(appointmentobject, ap.getClientID(), 1, lastModified, inFolder));
                        break;
                    }
                    if (!appointmentobject.getAlarmFlag()) {
                        appointmentobject.removeAlarm();
                    }
                    appointmentobject.setParentFolderID(inFolder);
                    pendingInvocations.add(new QueuedAppointment(appointmentobject, ap.getClientID(), 1, lastModified, inFolder));
                    break;
                }
                case 2: {
                    LOG.debug("delete appointment: {} in folder: {}", (Object)appointmentobject.getObjectID(), (Object)inFolder);
                    pendingInvocations.add(new QueuedAppointment(appointmentobject, ap.getClientID(), 2, lastModified, inFolder));
                    break;
                }
                case 3: {
                    pendingInvocations.add(new QueuedAppointment(appointmentobject, ap.getClientID(), 3, lastModified, inFolder));
                    break;
                }
                default: {
                    LOG.debug("invalid method: {}", (Object)method);
                    break;
                }
            }
        } else {
            parser.next();
        }
    }

    private void sanitize(Appointment appointmentobject) {
        if (!appointmentobject.getAlarmFlag()) {
            appointmentobject.setAlarm(-1);
        }
        if (appointmentobject.containsRecurrenceType() && appointmentobject.getRecurrenceType() != 0 && !this.isLimitedSeries(appointmentobject)) {
            appointmentobject.setUntil(null);
        }
        if (!appointmentobject.containsRecurrenceType()) {
            appointmentobject.setRecurrenceType(0);
        }
    }

    private boolean isLimitedSeries(Appointment appointmentobject) {
        return appointmentobject.containsOccurrence() || appointmentobject.containsUntil();
    }

    @Override
    protected void performActions(OutputStream os, Session session, PendingInvocations<AppointmentSQLInterface> pendingInvocations) throws IOException {
        AppointmentSQLInterface appointmentsSQL = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
        while (!pendingInvocations.isEmpty()) {
            QueuedAppointment qapp = (QueuedAppointment)pendingInvocations.poll();
            if (null == qapp) continue;
            qapp.setLastModifiedCache(pendingInvocations.getLastModifiedCache());
            qapp.actionPerformed(appointmentsSQL, os, session.getUserId());
        }
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int objectId, int folderId, OutputStream os) throws Exception {
        User userObj = UserStorage.getInstance().getUser(sessionObj.getUserId(), ctx);
        AppointmentWriter appointmentwriter = new AppointmentWriter(userObj, ctx, sessionObj);
        appointmentwriter.startWriter(objectId, folderId, os);
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int folderId, boolean bModified, boolean bDelete, Date lastsync, OutputStream os) throws Exception {
        this.startWriter(sessionObj, ctx, folderId, bModified, bDelete, false, lastsync, os);
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int folderId, boolean bModified, boolean bDelete, boolean bList, Date lastsync, OutputStream os) throws Exception {
        User userObj = UserStorage.getInstance().getUser(sessionObj.getUserId(), ctx);
        AppointmentWriter appointmentwriter = new AppointmentWriter(userObj, ctx, sessionObj);
        appointmentwriter.startWriter(bModified, bDelete, bList, folderId, lastsync, os);
    }

    @Override
    protected boolean hasModulePermission(Session sessionObj, Context ctx) {
        UserConfiguration uc = UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx);
        return uc.hasWebDAVXML() && uc.hasCalendar();
    }

    @Override
    protected void decrementRequests() {
        MonitoringInfo.decrementNumberOfConnections((int)2);
    }

    @Override
    protected void incrementRequests() {
        MonitoringInfo.incrementNumberOfConnections((int)2);
    }

    private final class QueuedAppointment
    implements QueuedAction<AppointmentSQLInterface> {
        private final CalendarDataObject appointmentobject;
        private final String clientId;
        private final int action;
        private final Date lastModified;
        private final int inFolder;
        private LastModifiedCache lastModifiedCache;

        public QueuedAppointment(CalendarDataObject appointmentobject, String clientId, int action, Date lastModified, int inFolder) {
            this.appointmentobject = appointmentobject;
            this.clientId = clientId;
            this.action = action;
            this.lastModified = lastModified;
            this.inFolder = inFolder;
            this.lastModifiedCache = new LastModifiedCache();
        }

        @Override
        public void actionPerformed(AppointmentSQLInterface appointmentsSQL, OutputStream os, int user) throws IOException {
            XMLOutputter xo = new XMLOutputter();
            try {
                boolean hasConflicts = false;
                Appointment[] conflicts = null;
                switch (this.action) {
                    case 1: {
                        if (this.appointmentobject.containsObjectID()) {
                            if (this.lastModified == null) {
                                throw WebdavExceptionCode.MISSING_FIELD.create("last_modified");
                            }
                            Date currentLastModified = this.lastModifiedCache.getLastModified(this.appointmentobject.getObjectID(), this.lastModified);
                            this.lastModifiedCache.update(this.appointmentobject.getObjectID(), this.appointmentobject.getRecurrenceID(), this.lastModified);
                            conflicts = appointmentsSQL.updateAppointmentObject(this.appointmentobject, this.inFolder, currentLastModified);
                            boolean bl = hasConflicts = conflicts != null;
                            if (hasConflicts) break;
                            this.lastModifiedCache.update(this.appointmentobject.getObjectID(), this.appointmentobject.getRecurrenceID(), this.appointmentobject.getLastModified());
                            break;
                        }
                        conflicts = appointmentsSQL.insertAppointmentObject(this.appointmentobject);
                        boolean bl = hasConflicts = conflicts != null;
                        if (hasConflicts) break;
                        this.lastModifiedCache.update(this.appointmentobject.getObjectID(), this.appointmentobject.getRecurrenceID(), this.appointmentobject.getLastModified());
                        break;
                    }
                    case 2: {
                        LOG.debug("delete appointment: {} in folder: {}", (Object)this.appointmentobject.getObjectID(), (Object)this.inFolder);
                        if (this.lastModified == null) {
                            throw WebdavExceptionCode.MISSING_FIELD.create("last_modified");
                        }
                        appointmentsSQL.deleteAppointmentObject(this.appointmentobject, this.inFolder, this.lastModified);
                        break;
                    }
                    case 3: {
                        appointmentsSQL.setUserConfirmation(this.appointmentobject.getObjectID(), this.appointmentobject.getParentFolderID(), user, this.appointmentobject.getConfirm(), this.appointmentobject.getConfirmMessage());
                        break;
                    }
                    default: {
                        throw WebdavExceptionCode.INVALID_ACTION.create(this.action);
                    }
                }
                if (hasConflicts) {
                    calendar.this.writeResponse(this.appointmentobject, 409, "[1006] Appointments Conflicted", this.clientId, os, xo, conflicts);
                } else {
                    calendar.this.writeResponse(this.appointmentobject, 200, "[1200] OK", this.clientId, os, xo);
                }
            }
            catch (OXException exc) {
                if (exc.isMandatory()) {
                    LOG.debug("parsePropChilds", (Throwable)exc);
                    calendar.this.writeResponse(this.appointmentobject, 409, calendar.this.getErrorMessage(exc, "[%s] Missing field"), this.clientId, os, xo);
                } else if (exc.isNoPermission()) {
                    LOG.debug("parsePropChilds", (Throwable)exc);
                    calendar.this.writeResponse(this.appointmentobject, 403, calendar.this.getErrorMessage(exc, "[%s] No permission"), this.clientId, os, xo);
                } else if (exc.isConflict()) {
                    LOG.debug("parsePropChilds", (Throwable)exc);
                    calendar.this.writeResponse(this.appointmentobject, 409, "[1000] This object was modified on the server", this.clientId, os, xo);
                } else if (exc.isNotFound()) {
                    LOG.debug("parsePropChilds", (Throwable)exc);
                    calendar.this.writeResponse(this.appointmentobject, 404, "[1001] Object not found", this.clientId, os, xo);
                } else if (exc.getCategory() == Category.CATEGORY_TRUNCATED) {
                    LOG.debug("parsePropChilds", (Throwable)exc);
                    calendar.this.writeResponse(this.appointmentobject, 409, calendar.this.getErrorMessage(exc, "[%s] invalid user input"), this.clientId, os, xo);
                } else {
                    LOG.error("parsePropChilds", (Throwable)exc);
                    calendar.this.writeResponse(this.appointmentobject, 500, calendar.this.getErrorMessage(exc, "[%s] Server Error - ") + exc.toString(), this.clientId, os, xo);
                }
            }
            catch (Exception exc) {
                LOG.error("parsePropChilds", (Throwable)exc);
                calendar.this.writeResponse(this.appointmentobject, 500, calendar.this.getErrorMessage("[%s] Server Error - ", "undefinied error") + exc.toString(), this.clientId, os, xo);
            }
        }

        public void setLastModifiedCache(LastModifiedCache lastModifiedCache) {
            this.lastModifiedCache = lastModifiedCache;
        }
    }
}

