/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.ratelimit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.openexchange.config.ConfigurationService;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.java.Strings;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.images.ImageTransformationUtility;
import com.openexchange.tools.servlet.CountingHttpServletRequest;
import com.openexchange.tools.servlet.http.Cookies;
import com.openexchange.tools.servlet.ratelimit.Key;
import com.openexchange.tools.servlet.ratelimit.KeyPartProvider;
import com.openexchange.tools.servlet.ratelimit.Rate;
import com.openexchange.tools.servlet.ratelimit.RateLimitedException;
import com.openexchange.tools.servlet.ratelimit.impl.RateImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RateLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimiter.class);
    private static final KeyPartProvider HTTP_SESSION_KEY_PART_PROVIDER = new KeyPartProvider(){

        @Override
        public String getValue(HttpServletRequest servletRequest) {
            Map<String, Cookie> cookies = Cookies.cookieMapFor(servletRequest);
            if (null == cookies) {
                return null;
            }
            Cookie cookie = cookies.get("JSESSIONID");
            return null == cookie ? null : cookie.getValue();
        }
    };
    private static volatile List<KeyPartProvider> keyPartProviders;
    private static volatile Boolean considerRemotePort;
    private static volatile Cache<Key, Rate> bucketMap;
    private static volatile Integer maxRate;
    private static volatile Integer maxRateTimeWindow;
    private static volatile Boolean omitLocals;
    private static final Set<String> LOCALS;
    private static final String LINE_SEP;
    private static final long LAST_RATE_LIMIT_LOG_THRESHOLD = 60000L;
    private static final AtomicLong PROCESSED_REQUESTS;
    private static volatile List<StringChecker> userAgentCheckers;
    private static volatile List<StringChecker> remoteAddressCheckers;
    private static final Cache<String, Boolean> CACHE_AGENTS;
    private static final Cache<String, Boolean> CACHE_REMOTE_ADDRS;
    private static volatile List<String> modules;
    private static final Cache<String, Boolean> CACHE_PATHS;

    private RateLimiter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<KeyPartProvider> keyPartProviders() {
        List<KeyPartProvider> tmp = keyPartProviders;
        if (null != tmp) return tmp;
        Class<CountingHttpServletRequest> clazz = CountingHttpServletRequest.class;
        synchronized (CountingHttpServletRequest.class) {
            tmp = keyPartProviders;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Collections.emptyList();
            }
            String sProviders = service.getProperty("com.openexchange.servlet.maxRateKeyPartProviders");
            if (Strings.isEmpty((String)sProviders)) {
                tmp = Collections.emptyList();
            } else {
                LinkedList<KeyPartProvider> list = new LinkedList<KeyPartProvider>();
                for (String sProvider : Strings.splitByComma((String)sProviders)) {
                    String s = Strings.asciiLowerCase((String)sProvider);
                    if ("http-session".equals(s)) {
                        list.add(HTTP_SESSION_KEY_PART_PROVIDER);
                        continue;
                    }
                    if (s.startsWith("cookie-")) {
                        list.add(new CookieKeyPartProvider(s.substring(7)));
                        continue;
                    }
                    if (s.startsWith("header-")) {
                        list.add(new HeaderKeyPartProvider(s.substring(7)));
                        continue;
                    }
                    if (!s.startsWith("parameter-")) continue;
                    list.add(new ParameterKeyPartProvider(s.substring(10)));
                }
                tmp = Collections.unmodifiableList(list);
            }
            keyPartProviders = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean considerRemotePort() {
        Boolean tmp = considerRemotePort;
        if (null != tmp) return tmp;
        Class<CountingHttpServletRequest> clazz = CountingHttpServletRequest.class;
        synchronized (CountingHttpServletRequest.class) {
            tmp = considerRemotePort;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            considerRemotePort = tmp = Boolean.valueOf(service.getProperty("com.openexchange.servlet.maxRateConsiderRemotePort", "false"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Cache<Key, Rate> bucketMap() {
        Cache tmp = bucketMap;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = bucketMap;
            if (null != tmp) return tmp;
            ConfigurationService configService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == configService) {
                LOG.info(RateLimiter.class.getSimpleName() + " not yet fully initialized; awaiting " + ConfigurationService.class.getSimpleName());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            long maximumSize = configService.getIntProperty("com.openexchange.servlet.maxActiveSessions", 250000);
            if (0L >= maximumSize) {
                maximumSize = 250000L;
            }
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().concurrencyLevel(16).maximumSize(maximumSize).initialCapacity(16).expireAfterAccess((long)((int)(1.1 * (double)RateLimiter.maxRateTimeWindow())), TimeUnit.MILLISECONDS);
            if (LOG.isTraceEnabled()) {
                cacheBuilder.removalListener((RemovalListener)new RemovalListener<Key, Rate>(){

                    public void onRemoval(RemovalNotification<Key, Rate> notification) {
                        LOG.trace("Rate limit slot removed for {}, last accessed at {}", notification.getKey(), (Object)((Rate)notification.getValue()).lastAccessTime());
                    }
                });
            }
            bucketMap = tmp = cacheBuilder.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int maxRate() {
        Integer tmp = maxRate;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = maxRate;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 500;
            }
            maxRate = tmp = Integer.valueOf(service.getProperty("com.openexchange.servlet.maxRate", "500"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int maxRateTimeWindow() {
        Integer tmp = maxRateTimeWindow;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = maxRateTimeWindow;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 300000;
            }
            maxRateTimeWindow = tmp = Integer.valueOf(service.getProperty("com.openexchange.servlet.maxRateTimeWindow", "300000"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean omitLocals() {
        Boolean tmp = omitLocals;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = omitLocals;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            omitLocals = tmp = Boolean.valueOf(service.getProperty("com.openexchange.servlet.maxRateOmitLocals", "false"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static long getProcessedRequests() {
        return PROCESSED_REQUESTS.get();
    }

    public static long getSlotCount() {
        return RateLimiter.getSlotCount(false);
    }

    public static long getSlotCount(boolean purge) {
        Cache<Key, Rate> bucketMap = RateLimiter.bucketMap();
        if (null == bucketMap) {
            return 0L;
        }
        if (purge) {
            bucketMap.cleanUp();
        }
        return bucketMap.size();
    }

    public static void clear() {
        Cache<Key, Rate> bucketMap = RateLimiter.bucketMap();
        if (null != bucketMap) {
            bucketMap.invalidateAll();
            bucketMap.cleanUp();
        }
    }

    public static void checkRequest(HttpServletRequest httpRequest) {
        int maxRate = RateLimiter.maxRate();
        if (maxRate <= 0) {
            return;
        }
        int maxRateTimeWindow = RateLimiter.maxRateTimeWindow();
        if (maxRateTimeWindow <= 0) {
            return;
        }
        if (RateLimiter.omitLocals() && LOCALS.contains(httpRequest.getServerName())) {
            return;
        }
        if (RateLimiter.lenientCheckForRequest(httpRequest)) {
            return;
        }
        RateLimiter.checkRateLimitFor(new Key(httpRequest), maxRate, maxRateTimeWindow, httpRequest);
    }

    public static void checkRateLimitFor(Key key, int maxRate, int maxRateTimeWindow, HttpServletRequest optRequest) {
        RateLimiter.checkRateLimitForRequest(key, maxRate, maxRateTimeWindow, true, optRequest);
    }

    public static boolean optRateLimitFor(Key key, int maxRate, int maxRateTimeWindow, HttpServletRequest optRequest) {
        return RateLimiter.checkRateLimitForRequest(key, maxRate, maxRateTimeWindow, false, optRequest);
    }

    private static boolean checkRateLimitForRequest(final Key key, final int maxRate, final int maxRateTimeWindow, boolean createIfAbsent, HttpServletRequest optRequest) {
        Rate.Result res;
        Rate rate;
        Cache<Key, Rate> bucketMap = RateLimiter.bucketMap();
        if (null == bucketMap) {
            return false;
        }
        PROCESSED_REQUESTS.incrementAndGet();
        while (true) {
            if (createIfAbsent) {
                try {
                    rate = (Rate)bucketMap.get((Object)key, (Callable)new Callable<Rate>(){

                        @Override
                        public Rate call() throws Exception {
                            LOG.trace("Inserting new rate limit slot for {}", (Object)key);
                            return new RateImpl(maxRate, maxRateTimeWindow, TimeUnit.MILLISECONDS);
                        }
                    });
                }
                catch (ExecutionException e) {
                    LOG.warn("Error checking rate limit for '{}'", (Object)key, (Object)e.getCause());
                    return false;
                }
            } else {
                rate = (Rate)bucketMap.getIfPresent((Object)key);
                if (null == rate) {
                    return false;
                }
            }
            res = rate.consume(System.currentTimeMillis());
            if (Rate.Result.DEPRECATED != res) break;
            bucketMap.invalidate((Object)key);
        }
        if (Rate.Result.SUCCESS == res) {
            return true;
        }
        if (null != optRequest) {
            RateLimiter.logRateLimitExceeded(rate, optRequest);
        }
        throw new RateLimitedException("429 Too Many Requests", maxRateTimeWindow / 1000);
    }

    private static void logRateLimitExceeded(Rate rate, HttpServletRequest servletRequest) {
        AtomicLong lastAtomicLogStamp = rate.getLastLogStamp();
        long lastLogStamp = lastAtomicLogStamp.get();
        long now = System.currentTimeMillis();
        if (now - lastLogStamp > 60000L && lastAtomicLogStamp.compareAndSet(lastLogStamp, now)) {
            LOG.info("Request with IP '{}' to path '{}' has been rate limited.{}", new Object[]{servletRequest.getRemoteAddr(), servletRequest.getServletPath(), LINE_SEP});
        } else {
            LOG.debug("Request with IP '{}' to path '{}' has been rate limited.{}", new Object[]{servletRequest.getRemoteAddr(), servletRequest.getServletPath(), LINE_SEP});
        }
    }

    public static void removeRateLimit(HttpServletRequest httpRequest) {
        RateLimiter.removeRateLimit(new Key(httpRequest));
    }

    public static void removeRateLimit(Key key) {
        if (null == key) {
            return;
        }
        Cache<Key, Rate> bucketMap = RateLimiter.bucketMap();
        if (null == bucketMap) {
            return;
        }
        bucketMap.invalidate((Object)key);
    }

    public static void doubleRateLimitWindow(Key key) {
        if (null == key) {
            return;
        }
        Cache<Key, Rate> bucketMap = RateLimiter.bucketMap();
        if (null == bucketMap) {
            return;
        }
        Rate rate = (Rate)bucketMap.getIfPresent((Object)key);
        if (null != rate) {
            rate.setTimeInMillis(rate.getTimeInMillis() << 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<StringChecker> userAgentCheckers() {
        List<StringChecker> tmp = userAgentCheckers;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = userAgentCheckers;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Collections.emptyList();
            }
            String defaultValue = "\"Open-Xchange .NET HTTP Client*\", \"Open-Xchange USM HTTP Client*\", \"Jakarta Commons-HttpClient*\"";
            String sProviders = service.getProperty("com.openexchange.servlet.maxRateLenientClients", "\"Open-Xchange .NET HTTP Client*\", \"Open-Xchange USM HTTP Client*\", \"Jakarta Commons-HttpClient*\"");
            if (Strings.isEmpty((String)sProviders)) {
                tmp = Collections.emptyList();
            } else {
                LinkedList<StringChecker> list = new LinkedList<StringChecker>();
                LinkedList<String> startsWiths = new LinkedList<String>();
                for (String sChecker : Strings.splitByComma((String)sProviders)) {
                    String s = RateLimiter.unquote(sChecker);
                    if (Strings.isEmpty((String)s)) continue;
                    if (RateLimiter.isStartsWith(s = s.trim())) {
                        startsWiths.add(s.substring(0, s.length() - 1));
                        continue;
                    }
                    if (s.indexOf(42) >= 0 || s.indexOf(63) >= 0) {
                        list.add(new PatternUserAgentChecker(s));
                        continue;
                    }
                    list.add(new IgnoreCaseStringChecker(s));
                }
                if (!startsWiths.isEmpty()) {
                    list.add(0, new StartsWithStringChecker(startsWiths));
                }
                tmp = list.isEmpty() ? Collections.emptyList() : (1 == list.size() ? Collections.singletonList(list.get(0)) : Collections.unmodifiableList(list));
            }
            userAgentCheckers = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<StringChecker> remoteAddressCheckers() {
        List<StringChecker> tmp = remoteAddressCheckers;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = remoteAddressCheckers;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Collections.emptyList();
            }
            String sRemoteAddrs = service.getProperty("com.openexchange.servlet.maxRateLenientRemoteAddresses");
            if (Strings.isEmpty((String)sRemoteAddrs)) {
                tmp = Collections.emptyList();
            } else {
                LinkedList<StringChecker> list = new LinkedList<StringChecker>();
                LinkedList<String> startsWiths = new LinkedList<String>();
                for (String sChecker : Strings.splitByComma((String)sRemoteAddrs)) {
                    String s = RateLimiter.unquote(sChecker);
                    if (Strings.isEmpty((String)s)) continue;
                    if (RateLimiter.isStartsWith(s = s.trim())) {
                        startsWiths.add(s.substring(0, s.length() - 1));
                        continue;
                    }
                    if (s.indexOf(42) >= 0 || s.indexOf(63) >= 0) {
                        list.add(new PatternUserAgentChecker(s));
                        continue;
                    }
                    list.add(new IgnoreCaseStringChecker(s));
                }
                if (!startsWiths.isEmpty()) {
                    list.add(0, new StartsWithStringChecker(startsWiths));
                }
                tmp = list.isEmpty() ? Collections.emptyList() : (1 == list.size() ? Collections.singletonList(list.get(0)) : Collections.unmodifiableList(list));
            }
            remoteAddressCheckers = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private static boolean lenientCheckForUserAgent(String userAgent) {
        if (null != userAgent) {
            Boolean result = (Boolean)CACHE_AGENTS.getIfPresent((Object)userAgent);
            if (null == result) {
                for (StringChecker checker : RateLimiter.userAgentCheckers()) {
                    if (!checker.matches(userAgent)) continue;
                    result = Boolean.TRUE;
                    break;
                }
                if (null == result) {
                    result = Boolean.FALSE;
                }
                CACHE_AGENTS.put((Object)userAgent, (Object)result);
            }
            return result;
        }
        return false;
    }

    private static boolean lenientCheckForRemoteAddress(String remoteAddress) {
        if (null != remoteAddress) {
            Boolean result = (Boolean)CACHE_REMOTE_ADDRS.getIfPresent((Object)remoteAddress);
            if (null == result) {
                for (StringChecker checker : RateLimiter.remoteAddressCheckers()) {
                    if (!checker.matches(remoteAddress)) continue;
                    result = Boolean.TRUE;
                    break;
                }
                if (null == result) {
                    result = Boolean.FALSE;
                }
                CACHE_REMOTE_ADDRS.put((Object)remoteAddress, (Object)result);
            }
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> modules() {
        List<String> tmp = modules;
        if (null != tmp) return tmp;
        Class<RateLimiter> clazz = RateLimiter.class;
        synchronized (RateLimiter.class) {
            tmp = modules;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Arrays.asList("rt", "system");
            }
            String defaultValue = "rt, system";
            String sModules = service.getProperty("com.openexchange.servlet.maxRateLenientModules", "rt, system");
            if (Strings.isEmpty((String)sModules)) {
                tmp = Collections.emptyList();
            } else {
                LinkedHashSet<String> set = new LinkedHashSet<String>();
                for (String sModule : Strings.splitByComma((String)sModules)) {
                    String s = RateLimiter.unquote(sModule);
                    if (Strings.isEmpty((String)s)) continue;
                    s = Strings.asciiLowerCase((String)s.trim());
                    set.add(s);
                }
                tmp = set.isEmpty() ? Collections.emptyList() : (1 == set.size() ? Collections.singletonList(set.iterator().next()) : Collections.unmodifiableList(new ArrayList(set)));
            }
            modules = tmp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private static boolean lenientCheckForRequest(HttpServletRequest servletRequest) {
        String requestURI = servletRequest.getRequestURI();
        Boolean result = (Boolean)CACHE_PATHS.getIfPresent((Object)requestURI);
        if (null == result) {
            StringBuilder sb = new StringBuilder(Strings.asciiLowerCase((String)ServerServiceRegistry.getServize(DispatcherPrefixService.class).getPrefix()));
            int reslen = sb.length();
            String lcRequestURI = Strings.asciiLowerCase((String)requestURI);
            for (String module : RateLimiter.modules()) {
                sb.setLength(reslen);
                if (!lcRequestURI.startsWith(sb.append(module).toString())) continue;
                result = Boolean.TRUE;
                break;
            }
            if (null == result) {
                result = Boolean.FALSE;
            }
            CACHE_PATHS.put((Object)requestURI, (Object)result);
        }
        if (result.booleanValue()) {
            return true;
        }
        if (RateLimiter.lenientCheckForUserAgent(servletRequest.getHeader("User-Agent"))) {
            return true;
        }
        if (RateLimiter.lenientCheckForRemoteAddress(servletRequest.getRemoteAddr())) {
            return true;
        }
        return ImageTransformationUtility.seemsLikeThumbnailRequest(servletRequest);
    }

    static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\') {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }

    private static boolean isStartsWith(String s) {
        if (!s.endsWith("*")) {
            return false;
        }
        int mlen = s.length() - 1;
        int pos = s.indexOf("?");
        if (pos >= 0) {
            return false;
        }
        pos = s.indexOf("*");
        return pos < 0 || pos >= mlen;
    }

    private static String unquote(String s) {
        if (!Strings.isEmpty((String)s) && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    static {
        LOCALS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("localhost", "127.0.0.1", "::1")));
        LINE_SEP = System.getProperty("line.separator");
        PROCESSED_REQUESTS = new AtomicLong();
        CACHE_AGENTS = CacheBuilder.newBuilder().maximumSize(250L).expireAfterWrite(30L, TimeUnit.MINUTES).build();
        CACHE_REMOTE_ADDRS = CacheBuilder.newBuilder().maximumSize(2500L).expireAfterWrite(30L, TimeUnit.MINUTES).build();
        CACHE_PATHS = CacheBuilder.newBuilder().maximumSize(1500L).expireAfterWrite(2L, TimeUnit.HOURS).build();
    }

    private static final class PatternUserAgentChecker
    implements StringChecker {
        private final Pattern pattern;

        PatternUserAgentChecker(String wildcard) {
            this.pattern = Pattern.compile(RateLimiter.wildcardToRegex(wildcard), 2);
        }

        @Override
        public boolean matches(String identifier) {
            return this.pattern.matcher(identifier).matches();
        }
    }

    private static final class IgnoreCaseStringChecker
    implements StringChecker {
        private final String userAgent;

        IgnoreCaseStringChecker(String userAgent) {
            this.userAgent = Strings.asciiLowerCase((String)userAgent);
        }

        @Override
        public boolean matches(String identifier) {
            return this.userAgent.equals(Strings.asciiLowerCase((String)identifier));
        }
    }

    private static final class StartsWithStringChecker
    implements StringChecker {
        private final String[] prefixes;

        StartsWithStringChecker(List<String> prefixes) {
            int size = prefixes.size();
            String[] newArray = new String[size];
            for (int i = 0; i < size; ++i) {
                newArray[i] = Strings.asciiLowerCase((String)prefixes.get(i));
            }
            this.prefixes = newArray;
        }

        @Override
        public boolean matches(String identifier) {
            String lc = Strings.asciiLowerCase((String)identifier);
            for (String prefix : this.prefixes) {
                if (!lc.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
    }

    private static interface StringChecker {
        public boolean matches(String var1);
    }

    private static final class ParameterKeyPartProvider
    implements KeyPartProvider {
        private final String paramName;

        ParameterKeyPartProvider(String paramName) {
            this.paramName = paramName;
        }

        @Override
        public String getValue(HttpServletRequest servletRequest) {
            return servletRequest.getParameter(this.paramName);
        }
    }

    private static final class HeaderKeyPartProvider
    implements KeyPartProvider {
        private final String headerName;

        HeaderKeyPartProvider(String headerName) {
            this.headerName = headerName;
        }

        @Override
        public String getValue(HttpServletRequest servletRequest) {
            return servletRequest.getHeader(this.headerName);
        }
    }

    private static final class CookieKeyPartProvider
    implements KeyPartProvider {
        private final String cookieName;

        CookieKeyPartProvider(String cookieName) {
            this.cookieName = Strings.asciiLowerCase((String)cookieName);
        }

        @Override
        public String getValue(HttpServletRequest servletRequest) {
            Map<String, Cookie> cookies = Cookies.cookieMapFor(servletRequest);
            if (null == cookies) {
                return null;
            }
            Cookie cookie = cookies.get(this.cookieName);
            return null == cookie ? null : cookie.getValue();
        }
    }
}

