/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;

public final class OldOXFolderIteratorSQL {
    private static final String STR_EMPTY = "";
    private static final String STR_SELECT = "SELECT ";
    private static final String STR_OT = "ot";
    private static final String STR_ORDER_BY = "ORDER BY ";
    private static final String STR_FUID = "fuid";
    private static final String STR_DEFAULTFLAG_DESC = "default_flag DESC";
    private static final String STR_FNAME = "fname";
    private static final String STR_GROUP_BY = "GROUP BY ";
    private static final int[] DEF_MODULES = new int[]{2, 3, 1};
    private static final String SQL_SEL_ALL_PUB = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND type = ? ORDER BY fuid";
    private static final String SQL_SEL_ALL_PUB_MODULE = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND type = ? AND module = ? ORDER BY fuid";
    private static final String SQL_SELECT_FOLDERS_START = new StringBuilder(200).append("SELECT ").append(FolderObjectIterator.getFieldsForSQL("ot")).append(" FROM oxfolder_tree AS ot").append(" WHERE (cid = ?) ").toString();

    private OldOXFolderIteratorSQL() {
    }

    private static String getSQLUserVisibleFolders(String fields, String permissionIds, String accessibleModules, String additionalCondition, String groupBy, String orderBy) {
        StringBuilder retValBuilder = new StringBuilder(256).append(STR_SELECT).append(fields).append(" FROM oxfolder_tree AS ot ").append("JOIN oxfolder_permissions AS op ON ot.fuid = op.fuid AND ot.cid = ? AND op.cid = ? ").append("WHERE (((ot.permission_flag = ").append(1).append(" AND ot.created_from = ?)) OR ").append("((op.admin_flag = 1 AND op.permission_id = ?) OR (op.fp > ").append(0).append(" AND op.permission_id IN ").append(permissionIds).append(")))");
        if (OXFolderProperties.isIgnoreSharedAddressbook()) {
            retValBuilder.append(" AND (ot.fuid != ").append(5).append(')');
        }
        if (accessibleModules != null) {
            retValBuilder.append(" AND (ot.module IN ").append(accessibleModules).append(')');
        }
        if (additionalCondition != null) {
            retValBuilder.append(' ').append(additionalCondition);
        }
        if (groupBy != null) {
            retValBuilder.append(' ').append(groupBy);
        }
        if (orderBy != null) {
            retValBuilder.append(' ').append(orderBy);
        }
        return retValBuilder.toString();
    }

    private static String getRootOrderBy(String tableAlias) {
        return OldOXFolderIteratorSQL.getOrderBy(tableAlias, STR_FUID);
    }

    private static String getSubfolderOrderBy(String tableAlias) {
        return OldOXFolderIteratorSQL.getOrderBy(tableAlias, STR_DEFAULTFLAG_DESC, STR_FNAME);
    }

    private static String getOrderBy(String tableAlias, String ... strings) {
        String alias;
        if (strings == null || strings.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(32);
        if (tableAlias == null) {
            alias = STR_EMPTY;
        } else {
            alias = sb.append(tableAlias).append('.').toString();
            sb.setLength(0);
        }
        sb.append(STR_ORDER_BY);
        sb.append(alias).append(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            sb.append(", ");
            sb.append(alias).append(strings[i]);
        }
        return sb.toString();
    }

    private static String getGroupBy(String tableAlias) {
        String alias = tableAlias == null ? STR_EMPTY : new StringBuilder(tableAlias.length() + 1).append(tableAlias).append('.').toString();
        return STR_GROUP_BY + alias + STR_FUID;
    }

    public static SearchIterator<FolderObject> getUserRootFoldersIterator(int userId, int[] memberInGroups, UserConfiguration userConfig, Context ctx) throws OXException, SearchIteratorException {
        StringBuilder condBuilder = new StringBuilder(32).append("AND (ot.type = ?) AND (ot.parent = ?)");
        if (!userConfig.hasFullSharedFolderAccess()) {
            condBuilder.append(" AND (ot.fuid != ").append(3).append(')');
        }
        if (!userConfig.hasInfostore()) {
            condBuilder.append(" AND (ot.fuid != ").append(9).append(')');
        }
        String sqlSelectStr = OldOXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(userConfig.getAccessibleModules()), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? OldOXFolderIteratorSQL.getGroupBy(STR_OT) : null, OldOXFolderIteratorSQL.getRootOrderBy(STR_OT));
        condBuilder = null;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, 5);
            stmt.setInt(pos, 0);
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, true, ctx, readCon, true);
    }

    public static SearchIterator<FolderObject> getVisibleSubfoldersIterator(int parentFolderId, int userId, int[] groups, Context ctx, UserConfiguration userConfig, Timestamp since) throws SQLException, OXException, OXException, SearchIteratorException {
        return OldOXFolderIteratorSQL.getVisibleSubfoldersIterator(parentFolderId, userId, groups, ctx, userConfig, since, null);
    }

    public static SearchIterator<FolderObject> getVisibleSubfoldersIterator(int parentFolderId, int userId, int[] groups, Context ctx, UserConfiguration userConfig, Timestamp since, Connection con) throws SQLException, OXException, OXException, SearchIteratorException {
        if (parentFolderId == 1) {
            return OldOXFolderIteratorSQL.getVisiblePrivateFolders(userId, groups, userConfig.getAccessibleModules(), ctx, since, con);
        }
        if (parentFolderId == 2) {
            return OldOXFolderIteratorSQL.getVisiblePublicFolders(userId, groups, userConfig.getAccessibleModules(), ctx, since, con);
        }
        if (parentFolderId == 3) {
            return OldOXFolderIteratorSQL.getVisibleSharedFolders(userId, groups, userConfig.getAccessibleModules(), ctx, since, con);
        }
        FolderObject parentFolder = new OXFolderAccess(con, ctx).getFolderObject(parentFolderId);
        EffectivePermission effectivePerm = parentFolder.getEffectiveUserPermission(userId, userConfig);
        if (((OCLPermission)effectivePerm).getFolderPermission() < 2) {
            return FolderObjectIterator.EMPTY_FOLDER_ITERATOR;
        }
        return OldOXFolderIteratorSQL.getVisibleSubfoldersIterator(parentFolder, userId, groups, userConfig.getAccessibleModules(), ctx, since, con);
    }

    private static SearchIterator<FolderObject> getVisiblePrivateFolders(int userId, int[] groups, int[] accessibleModules, Context ctx, Timestamp since, Connection con) throws OXException {
        StringBuilder condBuilder = new StringBuilder(32).append("AND (ot.type = ").append(1).append(" AND ot.created_from = ").append(userId).append(") AND (ot.parent = ?)").append(since == null ? STR_EMPTY : " AND (changing_date > ?)");
        String sqlSelectStr = OldOXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), StringCollection.getSqlInString(userId, groups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? OldOXFolderIteratorSQL.getGroupBy(STR_OT) : null, OldOXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            List<FolderObject> list;
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, 1);
            if (since != null) {
                stmt.setLong(pos, since.getTime());
            }
            if ((list = new FolderObjectIterator(rs = stmt.executeQuery(), stmt, false, ctx, readCon, closeCon).asList()).size() >= 3 && (list.get(0).getModule() != 2 || list.get(1).getModule() != 3 || list.get(2).getModule() != 1)) {
                FolderObject[] defaultFolders = new FolderObject[]{list.remove(0), list.remove(0), list.remove(0)};
                OldOXFolderIteratorSQL.switchElements(defaultFolders);
                for (int i = 0; i < defaultFolders.length; ++i) {
                    list.add(i, defaultFolders[i]);
                }
            }
            return new FolderObjectIterator(list, false);
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }

    private static void switchElements(FolderObject[] folders2) {
        for (int i = 0; i < folders2.length; ++i) {
            boolean switched = false;
            for (int j = 0; j < DEF_MODULES.length && !switched; ++j) {
                if (folders2[i].getModule() != DEF_MODULES[j] || i == j) continue;
                FolderObject tmp = folders2[j];
                folders2[j] = folders2[i];
                folders2[i] = tmp;
                switched = true;
            }
        }
    }

    private static SearchIterator<FolderObject> getVisiblePublicFolders(int userId, int[] groups, int[] accessibleModules, Context ctx, Timestamp since, Connection con) throws OXException, SearchIteratorException {
        StringBuilder condBuilder = new StringBuilder(32).append("AND (ot.type = ").append(2).append(") AND (ot.parent = ?)").append(since == null ? STR_EMPTY : " AND (changing_date > ?)");
        String sqlSelectStr = OldOXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), StringCollection.getSqlInString(userId, groups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? OldOXFolderIteratorSQL.getGroupBy(STR_OT) : null, OldOXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, 2);
            if (since != null) {
                stmt.setLong(pos, since.getTime());
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeCon);
    }

    private static SearchIterator<FolderObject> getVisibleSharedFolders(int userId, int[] groups, int[] accessibleModules, Context ctx, Timestamp since, Connection con) throws OXException, SearchIteratorException {
        return OldOXFolderIteratorSQL.getVisibleSharedFolders(userId, groups, accessibleModules, -1, ctx, since, con);
    }

    private static SearchIterator<FolderObject> getVisibleSubfoldersIterator(FolderObject parentFolder, int userId, int[] memberInGroups, int[] accessibleModules, Context ctx, Timestamp since, Connection con) throws OXException, SearchIteratorException {
        boolean shared = parentFolder.isShared(userId);
        StringBuilder condBuilder = new StringBuilder(32);
        if (shared) {
            condBuilder.append("AND (ot.type = ").append(1).append(" AND ot.created_from != ").append(userId).append(") ");
        }
        condBuilder.append("AND (ot.parent = ?)").append(since == null ? STR_EMPTY : " AND (changing_date > ?)");
        String sqlSelectStr = OldOXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? OldOXFolderIteratorSQL.getGroupBy(STR_OT) : null, OldOXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, parentFolder.getObjectID());
            if (since != null) {
                stmt.setLong(pos, since.getTime());
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeCon);
    }

    public static SearchIterator<FolderObject> getVisibleSharedFolders(int userId, int[] memberInGroups, int[] accessibleModules, int owner, Context ctx, Timestamp since, Connection con) throws OXException, SearchIteratorException {
        StringBuilder condBuilder = new StringBuilder(32).append("AND (ot.type = ").append(1).append(" AND ot.created_from != ").append(userId).append(')');
        if (owner > -1) {
            condBuilder.append(" AND (ot.created_from = ").append(owner).append(')');
        }
        condBuilder.append(since == null ? STR_EMPTY : " AND (changing_date > ?)");
        String sqlSelectStr = OldOXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? OldOXFolderIteratorSQL.getGroupBy(STR_OT) : null, OldOXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = con;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (null == readCon) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            if (since != null) {
                stmt.setLong(pos, since.getTime());
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeCon);
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersNotSeenInTreeView(int userId, int[] groups, UserConfiguration userConfig, Context ctx) throws OXException {
        return OldOXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeView(null, userId, groups, userConfig, ctx, null);
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersNotSeenInTreeView(int userId, int[] groups, UserConfiguration userConfig, Context ctx, Connection readCon) throws OXException {
        return OldOXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeView(null, userId, groups, userConfig, ctx, readCon);
    }

    public static SearchIterator<FolderObject> getVisibleFoldersNotSeenInTreeView(int module, int userId, int[] groups, UserConfiguration userConfig, Context ctx, Connection readCon) throws OXException {
        return OldOXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeView((Integer)module, userId, groups, userConfig, ctx, readCon);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SearchIterator<FolderObject> getVisibleFoldersNotSeenInTreeView(Integer module, int userId, int[] groups, UserConfiguration userConfig, Context ctx, Connection readCon) throws OXException {
        FolderObjectIterator folderObjectIterator;
        int size;
        Queue<FolderObject> q;
        int pos;
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection rc;
        block12: {
            rc = readCon;
            closeReadCon = false;
            stmt = null;
            rs = null;
            if (readCon == null) {
                rc = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            pos = 1;
            StringBuilder condBuilder = new StringBuilder(32).append("AND ot.type = ").append(2);
            if (null != module) {
                condBuilder.append(" AND ot.module = ").append(module);
            }
            String sqlSelectStr = OldOXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), StringCollection.getSqlInString(userId, groups), StringCollection.getSqlInString(userConfig.getAccessibleModules()), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? OldOXFolderIteratorSQL.getGroupBy(STR_OT) : null, OldOXFolderIteratorSQL.getOrderBy(STR_OT, "module", STR_FNAME));
            stmt = rc.prepareStatement(sqlSelectStr);
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos, userId);
            rs = stmt.executeQuery();
            q = new FolderObjectIterator(rs, stmt, false, ctx, rc, closeReadCon).asQueue();
            size = q.size();
            if (size != 0) break block12;
            rs = null;
            stmt = null;
            rc = null;
            FolderObjectIterator folderObjectIterator2 = FolderObjectIterator.EMPTY_FOLDER_ITERATOR;
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
            return folderObjectIterator2;
        }
        try {
            if (readCon == null) {
                rc = DBPool.pickup(ctx);
            }
            stmt = rc.prepareStatement(null == module ? SQL_SEL_ALL_PUB : SQL_SEL_ALL_PUB_MODULE);
            pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, 2);
            if (null != module) {
                stmt.setInt(pos, module);
            }
            rs = stmt.executeQuery();
            HashSet<Integer> nonVisibleSet = new HashSet<Integer>(1024);
            while (rs.next()) {
                nonVisibleSet.add(rs.getInt(1));
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            nonVisibleSet.removeAll(OldOXFolderIteratorSQL.queue2IDSet(q, size));
            Iterator iter = q.iterator();
            while (iter.hasNext()) {
                if (nonVisibleSet.contains(((FolderObject)iter.next()).getParentFolderID())) continue;
                iter.remove();
            }
            folderObjectIterator = new FolderObjectIterator(q, false);
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
                catch (Throwable t) {
                    throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, stmt, closeReadCon ? rc : null, true, ctx);
                throw throwable;
            }
        }
        return folderObjectIterator;
    }

    private static Set<Integer> queue2IDSet(Queue<FolderObject> q, int size) {
        HashSet<Integer> retval = new HashSet<Integer>(size);
        Iterator iter = q.iterator();
        for (int i = 0; i < size; ++i) {
            retval.add(((FolderObject)iter.next()).getObjectID());
        }
        return retval;
    }

    public static SearchIterator<FolderObject> getFoldersOnPathToRoot(int folderId, int userId, UserConfiguration userConfig, Locale locale, Context ctx) throws OXException, SearchIteratorException {
        ArrayList<FolderObject> folderList = new ArrayList<FolderObject>();
        OldOXFolderIteratorSQL.fillAncestor(folderList, folderId, userId, userConfig, locale, null, ctx);
        return new FolderObjectIterator(folderList, false);
    }

    private static void fillAncestor(List<FolderObject> folderList, int folderId, int userId, UserConfiguration userConfig, Locale locale, UserStorage userStoreArg, Context ctx) throws OXException {
        OXFolderAccess access = new OXFolderAccess(ctx);
        if (OldOXFolderIteratorSQL.checkForSpecialFolder(folderList, folderId, locale, access)) {
            return;
        }
        UserStorage userStore = userStoreArg;
        FolderObject fo = access.getFolderObject(folderId);
        try {
            if (!fo.getEffectiveUserPermission(userId, userConfig).isFolderVisible()) {
                if (folderList.isEmpty()) {
                    throw OXFolderExceptionCode.NOT_VISIBLE.create(folderId, userId, ctx.getContextId());
                }
                return;
            }
            if (fo.isShared(userId)) {
                String creatorDisplayName;
                folderList.add(fo);
                if (userStore == null) {
                    userStore = UserStorage.getInstance();
                }
                try {
                    creatorDisplayName = userStore.getUser(fo.getCreatedBy(), ctx).getDisplayName();
                }
                catch (OXException e) {
                    if (fo.getCreatedBy() != 0) {
                        throw e;
                    }
                    StringHelper strHelper = StringHelper.valueOf(locale);
                    creatorDisplayName = strHelper.getString("All users");
                }
                FolderObject virtualOwnerFolder = FolderObject.createVirtualFolderObject("u:" + fo.getCreatedBy(), creatorDisplayName, 5, true, 5);
                folderList.add(virtualOwnerFolder);
                fo = access.getFolderObject(3);
                fo.setFolderName(FolderObject.getFolderString(3, locale));
                folderList.add(fo);
                return;
            }
            if (fo.getType() == 2 && OldOXFolderIteratorSQL.hasNonVisibleParent(fo, userId, userConfig, access)) {
                int virtualParent;
                folderList.add(fo);
                switch (fo.getModule()) {
                    case 1: {
                        virtualParent = 11;
                        break;
                    }
                    case 2: {
                        virtualParent = 12;
                        break;
                    }
                    case 3: {
                        virtualParent = 13;
                        break;
                    }
                    case 8: {
                        virtualParent = 14;
                        break;
                    }
                    default: {
                        throw OXFolderExceptionCode.UNKNOWN_MODULE.create(STR_EMPTY, OXFolderUtility.folderModule2String(fo.getModule()), ctx.getContextId());
                    }
                }
                OldOXFolderIteratorSQL.checkForSpecialFolder(folderList, virtualParent, locale, access);
                return;
            }
            folderList.add(fo);
            if (fo.getParentFolderID() != 0) {
                OldOXFolderIteratorSQL.fillAncestor(folderList, fo.getParentFolderID(), userId, userConfig, locale, userStore, ctx);
            }
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }

    private static boolean checkForSpecialFolder(List<FolderObject> folderList, int folderId, Locale locale, OXFolderAccess access) throws OXException {
        boolean publicParent;
        FolderObject specialFolder;
        switch (folderId) {
            case 6: {
                specialFolder = access.getFolderObject(folderId);
                specialFolder.setFolderName(FolderObject.getFolderString(6, locale));
                publicParent = true;
                break;
            }
            case 11: {
                specialFolder = FolderObject.createVirtualFolderObject(11, FolderObject.getFolderString(11, locale), 5, true, 5);
                publicParent = true;
                break;
            }
            case 12: {
                specialFolder = FolderObject.createVirtualFolderObject(12, FolderObject.getFolderString(12, locale), 5, true, 5);
                publicParent = true;
                break;
            }
            case 13: {
                specialFolder = FolderObject.createVirtualFolderObject(13, FolderObject.getFolderString(13, locale), 5, true, 5);
                publicParent = true;
                break;
            }
            case 14: {
                specialFolder = FolderObject.createVirtualFolderObject(14, FolderObject.getFolderString(14, locale), 5, true, 5);
                publicParent = false;
                break;
            }
            default: {
                return false;
            }
        }
        folderList.add(specialFolder);
        int parentId = publicParent ? 2 : 9;
        FolderObject parent = access.getFolderObject(parentId);
        parent.setFolderName(FolderObject.getFolderString(parentId, locale));
        folderList.add(parent);
        return true;
    }

    private static boolean hasNonVisibleParent(FolderObject fo, int userId, UserConfiguration userConf, OXFolderAccess access) throws OXException, OXException, SQLException {
        if (fo.getParentFolderID() == 0) {
            return false;
        }
        return !access.getFolderObject(fo.getParentFolderID()).getEffectiveUserPermission(userId, userConf).isFolderVisible();
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfType(int userId, int[] memberInGroups, int[] accessibleModules, int type, int[] modules, Context ctx) throws OXException, SearchIteratorException {
        return OldOXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, memberInGroups, accessibleModules, type, modules, null, ctx);
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfType(int userId, int[] memberInGroups, int[] accessibleModules, int type, int[] modules, int parent, Context ctx) throws OXException, SearchIteratorException {
        return OldOXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, memberInGroups, accessibleModules, type, modules, (Integer)parent, ctx);
    }

    private static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfType(int userId, int[] memberInGroups, int[] accessibleModules, int type, int[] modules, Integer parent, Context ctx) throws OXException, SearchIteratorException {
        StringBuilder condBuilder = new StringBuilder(32).append("AND (ot.module IN (");
        condBuilder.append(modules[0]);
        for (int i = 1; i < modules.length; ++i) {
            condBuilder.append(", ").append(modules[i]);
        }
        condBuilder.append(")) AND (ot.type = ?");
        if (type == 3) {
            condBuilder.append(" AND ot.created_from != ").append(userId);
        }
        condBuilder.append(')');
        if (parent != null) {
            condBuilder.append(" AND (ot.parent = ").append(parent).append(')');
        }
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(OldOXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? OldOXFolderIteratorSQL.getGroupBy(STR_OT) : null, OldOXFolderIteratorSQL.getSubfolderOrderBy(STR_OT)));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos, type == 3 ? 1 : type);
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfModule(int userId, int[] memberInGroups, int[] accessibleModules, int module, Context ctx) throws OXException, SearchIteratorException {
        return OldOXFolderIteratorSQL.getAllVisibleFoldersIteratorOfModule(userId, memberInGroups, accessibleModules, module, ctx, null);
    }

    public static SearchIterator<FolderObject> getAllVisibleFoldersIteratorOfModule(int userId, int[] memberInGroups, int[] accessibleModules, int module, Context ctx, Connection readConArg) throws OXException, SearchIteratorException {
        String sqlSelectStr = OldOXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), "AND (ot.module = ?)", OXFolderProperties.isEnableDBGrouping() ? OldOXFolderIteratorSQL.getGroupBy(STR_OT) : null, OldOXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        boolean closeReadCon = readConArg == null;
        Connection readCon = closeReadCon ? DBPool.pickup(ctx) : readConArg;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos, module);
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, closeReadCon);
    }

    public static SearchIterator<FolderObject> getDeletedFoldersSince(Date since, int userId, int[] memberInGroups, int[] accessibleModules, Context ctx) throws OXException, SearchIteratorException {
        String fields = FolderObjectIterator.getFieldsForSQL(STR_OT);
        StringBuilder sqlBuilder = new StringBuilder(STR_SELECT).append(fields).append(" FROM del_oxfolder_tree AS ot JOIN del_oxfolder_permissions AS op ON ot.fuid = op.fuid AND ot.cid = ? AND op.cid = ? ").append("WHERE ((ot.permission_flag = ").append(2).append(" OR (ot.permission_flag = ").append(1).append(" AND ot.created_from = ?)) OR ").append("((op.admin_flag = 1 AND op.permission_id = ?) OR (op.fp > ? AND op.permission_id IN ").append(StringCollection.getSqlInString(userId, memberInGroups)).append("))) AND (changing_date > ?)").append(" AND (ot.module IN ").append(StringCollection.getSqlInString(accessibleModules)).append(')').append(OXFolderProperties.isEnableDBGrouping() ? " GROUP BY ot.fuid" : STR_EMPTY).append(" ORDER by ot.fuid");
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlBuilder.toString());
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, 0);
            stmt.setLong(pos, since.getTime());
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static SearchIterator<FolderObject> getModifiedFoldersSince(Date since, int userId, int[] memberInGroups, int[] accessibleModules, boolean userFoldersOnly, Context ctx) throws OXException, SearchIteratorException {
        StringBuilder condBuilder = new StringBuilder(32).append("AND (changing_date > ?) AND (module IN ").append(FolderObject.SQL_IN_STR_STANDARD_MODULES).append(')');
        if (userFoldersOnly) {
            condBuilder.append(" AND (ot.created_from = ").append(userId).append(") ");
        }
        String sqlSelectStr = OldOXFolderIteratorSQL.getSQLUserVisibleFolders(FolderObjectIterator.getFieldsForSQL(STR_OT), StringCollection.getSqlInString(userId, memberInGroups), StringCollection.getSqlInString(accessibleModules), condBuilder.toString(), OXFolderProperties.isEnableDBGrouping() ? OldOXFolderIteratorSQL.getGroupBy(STR_OT) : null, OldOXFolderIteratorSQL.getSubfolderOrderBy(STR_OT));
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            stmt.setLong(pos, since.getTime());
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }

    public static SearchIterator<FolderObject> getAllModifiedFoldersSince(Date since, Context ctx) throws OXException, SearchIteratorException {
        String sqlSelectStr = new StringBuilder(256).append(SQL_SELECT_FOLDERS_START).append("AND (changing_date > ?) AND (module IN ").append(FolderObject.SQL_IN_STR_STANDARD_MODULES_ALL).append(") ").append(OXFolderProperties.isEnableDBGrouping() ? OldOXFolderIteratorSQL.getGroupBy(STR_OT) : null).append(" ORDER by ot.fuid").toString();
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = DBPool.pickup(ctx);
            stmt = readCon.prepareStatement(sqlSelectStr);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setLong(pos, since.getTime());
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw e;
        }
        catch (Throwable t) {
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
        return new FolderObjectIterator(rs, stmt, false, ctx, readCon, true);
    }
}

