/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.transformations;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.imagetransformation.TransformedImage;
import com.openexchange.java.Streams;
import java.io.InputStream;

public class TransformedImageImpl
implements TransformedImage {
    private final int width;
    private final int height;
    private final long size;
    private final String formatName;
    private final byte[] imageData;
    private final ThresholdFileHolder imageFile;
    private final byte[] md5;
    private final int transformationExpenses;

    public TransformedImageImpl(int width, int height, long size, String formatName, byte[] imageData, byte[] md5, int transformationExpenses) {
        this.width = width;
        this.height = height;
        this.size = size;
        this.formatName = formatName;
        this.imageData = imageData;
        this.imageFile = null;
        this.md5 = md5;
        this.transformationExpenses = transformationExpenses;
    }

    public TransformedImageImpl(int width, int height, long size, String formatName, ThresholdFileHolder imageFile, byte[] md5, int transformationExpenses) {
        if (null == imageFile) {
            throw new IllegalArgumentException("imageFile must not be null");
        }
        this.width = width;
        this.height = height;
        this.size = size;
        this.formatName = formatName;
        this.imageData = null;
        this.imageFile = imageFile;
        this.md5 = md5;
        this.transformationExpenses = transformationExpenses;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getSize() {
        return this.size;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public byte[] getImageData() throws OXException {
        return null != this.imageData ? this.imageData : this.imageFile.toByteArray();
    }

    public InputStream getImageStream() throws OXException {
        return null != this.imageData ? Streams.newByteArrayInputStream((byte[])this.imageData) : this.imageFile.getStream();
    }

    public IFileHolder getImageFile() {
        return this.imageFile;
    }

    public byte[] getMD5() {
        return this.md5;
    }

    public int getTransformationExpenses() {
        return this.transformationExpenses;
    }

    public String toString() {
        return this.formatName + " | " + this.width + " x " + this.height + " | " + this.size + " bytes";
    }

    public void close() {
        ThresholdFileHolder imageFile = this.imageFile;
        if (null != imageFile) {
            imageFile.close();
        }
    }
}

