/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.imagetransformation.TransformationContext;
import com.openexchange.imagetransformation.TransformedImage;
import com.openexchange.imagetransformation.TransformedImageCreator;
import com.openexchange.java.Streams;
import com.openexchange.tools.images.transformations.TransformedImageImpl;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransformedImageCreator
implements TransformedImageCreator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTransformedImageCreator.class);

    public TransformedImage writeTransformedImage(BufferedImage image, String formatName, TransformationContext transformationContext, boolean needsCompression) throws IOException {
        TransformedImageImpl transformedImageImpl;
        if (null == image) {
            return null;
        }
        DigestOutputStream digestOutputStream = null;
        ThresholdFileHolder sink = new ThresholdFileHolder();
        try {
            digestOutputStream = new DigestOutputStream(sink.asOutputStream(), MessageDigest.getInstance("MD5"));
            if (needsCompression) {
                DefaultTransformedImageCreator.writeCompressed(image, formatName, digestOutputStream, transformationContext);
            } else {
                DefaultTransformedImageCreator.write(image, formatName, digestOutputStream);
            }
            byte[] md5 = digestOutputStream.getMessageDigest().digest();
            long size = sink.getLength();
            TransformedImageImpl retval = new TransformedImageImpl(image.getWidth(), image.getHeight(), size, formatName, sink, md5, transformationContext.getExpenses());
            sink = null;
            transformedImageImpl = retval;
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                Streams.close(digestOutputStream);
                Streams.close((Closeable)((Object)sink));
                throw throwable;
            }
        }
        Streams.close((Closeable)digestOutputStream);
        Streams.close((Closeable)((Object)sink));
        return transformedImageImpl;
    }

    private static void write(BufferedImage image, String formatName, OutputStream output) throws IOException {
        if (!ImageIO.write((RenderedImage)image, formatName, output)) {
            throw new IOException("no appropriate writer found for " + formatName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCompressed(BufferedImage image, String formatName, OutputStream output, TransformationContext transformationContext) throws IOException {
        ImageWriter writer = null;
        ImageInputStream imageOutputStream = null;
        try {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
            if (!(null != iter && iter.hasNext() || null != (iter = ImageIO.getImageWritersByMIMEType(formatName)) && iter.hasNext())) {
                throw new IOException("No image writer for format " + formatName);
            }
            writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            DefaultTransformedImageCreator.adjustCompressionParams(iwp);
            imageOutputStream = ImageIO.createImageOutputStream(output);
            writer.setOutput(imageOutputStream);
            IIOImage iioImage = new IIOImage(image, null, null);
            writer.write(null, iioImage, iwp);
            transformationContext.addExpense(1);
        }
        finally {
            if (null != writer) {
                writer.dispose();
            }
            if (null != imageOutputStream) {
                imageOutputStream.close();
            }
        }
    }

    private static void adjustCompressionParams(ImageWriteParam parameters) {
        try {
            parameters.setCompressionMode(2);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("", (Throwable)e);
        }
        try {
            parameters.setProgressiveMode(1);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("", (Throwable)e);
        }
        try {
            parameters.setCompressionQuality(0.8f);
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("", (Throwable)e);
        }
    }
}

