/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import com.openexchange.java.IPAddressUtil;
import com.openexchange.java.Strings;
import com.openexchange.mail.config.IPRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HostList {
    public static final HostList EMPTY = new HostList(Collections.emptyList(), Collections.emptySet(), Collections.emptySet());
    private final List<IPRange> ipRanges;
    private final Set<String> matchingAppendixHostNames;
    private final Set<String> matchingHostNames;

    public static HostList valueOf(String hostList) {
        if (Strings.isEmpty((String)hostList)) {
            return EMPTY;
        }
        String[] tokens = Strings.splitByComma((String)hostList);
        HashSet<String> matchingHostNames = new HashSet<String>(tokens.length);
        HashSet<String> matchingAppendixHostNames = new HashSet<String>(tokens.length);
        ArrayList<IPRange> ipRanges = new ArrayList<IPRange>(tokens.length);
        for (String token : tokens) {
            if (Strings.isEmpty((String)token)) continue;
            token = Strings.asciiLowerCase((String)token);
            boolean isIp = false;
            try {
                ipRanges.add(IPRange.parseRange(token));
                isIp = true;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (isIp) continue;
            if (token.startsWith("*")) {
                String appendixToken = token.substring(1);
                if (Strings.isEmpty((String)appendixToken) || appendixToken.indexOf(42) >= 0) {
                    throw new IllegalArgumentException("Invalid wild-card host name: " + token);
                }
                matchingAppendixHostNames.add(appendixToken);
                continue;
            }
            if (token.indexOf(42) > 0) {
                throw new IllegalArgumentException("Invalid wild-card host name: " + token);
            }
            matchingHostNames.add(token);
        }
        return new HostList(ipRanges, matchingAppendixHostNames, matchingHostNames);
    }

    private HostList(List<IPRange> ipRanges, Set<String> matchingAppendixHostNames, Set<String> matchingHostNames) {
        this.ipRanges = ipRanges;
        this.matchingAppendixHostNames = matchingAppendixHostNames.isEmpty() ? null : matchingAppendixHostNames;
        this.matchingHostNames = matchingHostNames;
    }

    public boolean contains(String hostName) {
        if (Strings.isEmpty((String)hostName)) {
            return false;
        }
        String toCheck = Strings.asciiLowerCase((String)hostName);
        byte[] octets = IPAddressUtil.textToNumericFormatV4((String)toCheck);
        if (null != octets) {
            for (IPRange ipRange : this.ipRanges) {
                if (!ipRange.containsIPv4(octets, toCheck)) continue;
                return true;
            }
        }
        if (null != (octets = IPAddressUtil.textToNumericFormatV6((String)toCheck))) {
            for (IPRange ipRange : this.ipRanges) {
                if (!ipRange.containsIPv6(octets, toCheck)) continue;
                return true;
            }
        }
        if (null != this.matchingAppendixHostNames) {
            for (String appendixHostName : this.matchingAppendixHostNames) {
                if (!toCheck.endsWith(appendixHostName)) continue;
                return true;
            }
        }
        return this.matchingHostNames.contains(Strings.asciiLowerCase((String)toCheck));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(32);
        builder.append("[");
        if (this.ipRanges != null) {
            builder.append("ipRanges=").append(this.ipRanges).append(", ");
        }
        if (this.matchingAppendixHostNames != null) {
            builder.append("wild-card_hostNames=[");
            Iterator<String> it = this.matchingAppendixHostNames.iterator();
            if (it.hasNext()) {
                builder.append('*').append(it.next());
                while (it.hasNext()) {
                    builder.append(", ").append('*').append(it.next());
                }
            }
            builder.append("], ");
        }
        if (this.matchingHostNames != null) {
            builder.append("hostNames=").append(this.matchingHostNames);
        }
        builder.append("]");
        return builder.toString();
    }
}

