/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.spamhandler;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.spamhandler.NoSpamHandler;
import com.openexchange.spamhandler.SpamHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpamHandlerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SpamHandlerRegistry.class);
    private static final Object PRESENT = new Object();
    private static final Map<String, SpamHandler> spamHandlers = new ConcurrentHashMap<String, SpamHandler>();
    private static final Map<String, Object> unknownSpamHandlers = new ConcurrentHashMap<String, Object>();

    private SpamHandlerRegistry() {
    }

    public static boolean hasSpamHandler(Session session, int accountId) throws OXException {
        return !"NoSpamHandler".equals(SpamHandlerRegistry.getSpamHandlerBySession(session, accountId).getSpamHandlerName());
    }

    public static boolean hasSpamHandler(MailAccount mailAccount) {
        SpamHandler handler;
        try {
            MailProvider provider = MailProviderRegistry.getRealMailProvider(mailAccount.getMailProtocol());
            handler = SpamHandlerRegistry.getSpamHandler0(mailAccount, new StaticMailProviderGetter(provider));
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            return false;
        }
        return handler == null ? false : !"NoSpamHandler".equals(handler.getSpamHandlerName());
    }

    public static SpamHandler getSpamHandlerBySession(Session session, int accountId) throws OXException {
        return SpamHandlerRegistry.getSpamHandlerBySession(session, accountId, null);
    }

    public static SpamHandler getSpamHandlerBySession(Session session, int accountId, MailProvider mailProvider) throws OXException {
        SpamHandler handler;
        MailSessionCache mailSessionCache = MailSessionCache.getInstance(session);
        String key = MailSessionParameterNames.getParamSpamHandler();
        try {
            handler = (SpamHandler)mailSessionCache.getParameter(accountId, key);
        }
        catch (ClassCastException e) {
            handler = null;
        }
        if (null != handler) {
            return handler;
        }
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        MailAccount mailAccount = storageService.getMailAccount(accountId, session.getUserId(), session.getContextId());
        MailProviderGetter mailProviderGetter = null == mailProvider ? new SessionMailProviderGetter(mailAccount.getMailProtocol()) : new SimpleMailProviderGetter(mailProvider);
        handler = SpamHandlerRegistry.getSpamHandler0(mailAccount, mailProviderGetter);
        mailSessionCache.putParameter(accountId, key, handler);
        return handler;
    }

    private static SpamHandler getSpamHandler0(MailAccount mailAccount, MailProviderGetter mailProviderGetter) throws OXException {
        MailProvider mailProvider;
        if (mailAccount.isDefaultAccount()) {
            mailProvider = mailProviderGetter.getMailProvider();
            if (null == mailProvider) {
                return NoSpamHandler.getInstance();
            }
        } else {
            LOG.debug("No spam handler for the external account with login {} (user {}) available per design.", (Object)mailAccount.getLogin(), (Object)mailAccount.getUserId());
            return NoSpamHandler.getInstance();
        }
        String spamHandlerName = mailProvider.getSpamHandler().getSpamHandlerName();
        SpamHandler handler = null != spamHandlerName && spamHandlerName.length() > 0 ? SpamHandlerRegistry.getSpamHandler(spamHandlerName) : mailProviderGetter.getMailProvider().getSpamHandler();
        return handler;
    }

    public static SpamHandler getSpamHandler(String registrationName) {
        if (null == registrationName) {
            LOG.warn("Given registration name is null. Using fallback spam handler '{}'", (Object)"NoSpamHandler");
            return NoSpamHandler.getInstance();
        }
        if ("NoSpamHandler".equals(registrationName) || unknownSpamHandlers.containsKey(registrationName)) {
            return NoSpamHandler.getInstance();
        }
        SpamHandler spamHandler = spamHandlers.get(registrationName);
        if (null == spamHandler) {
            LOG.warn("No spam handler found for registration name '{}'. Using fallback '{}'", (Object)registrationName, (Object)"NoSpamHandler");
            unknownSpamHandlers.put(registrationName, PRESENT);
            return NoSpamHandler.getInstance();
        }
        return spamHandler;
    }

    public static boolean registerSpamHandler(String registrationName, SpamHandler spamHandler) {
        if (null == registrationName || "NoSpamHandler".equals(registrationName)) {
            return false;
        }
        if (spamHandlers.containsKey(registrationName)) {
            return false;
        }
        try {
            spamHandlers.put(registrationName, spamHandler);
            unknownSpamHandlers.remove(registrationName);
            return true;
        }
        catch (RuntimeException t) {
            LOG.error("", (Throwable)t);
            return false;
        }
    }

    public static void unregisterAll() {
        spamHandlers.clear();
        unknownSpamHandlers.clear();
    }

    public static SpamHandler unregisterSpamHandler(SpamHandler spamHandler) {
        String registrationName = spamHandler.getSpamHandlerName();
        unknownSpamHandlers.put(registrationName, PRESENT);
        return spamHandlers.remove(registrationName);
    }

    public static SpamHandler unregisterSpamHandlerByName(String registrationName) {
        unknownSpamHandlers.put(registrationName, PRESENT);
        return spamHandlers.remove(registrationName);
    }

    private static final class StaticMailProviderGetter
    implements MailProviderGetter {
        private final MailProvider mailProvider;

        StaticMailProviderGetter(MailProvider mailProvider) {
            this.mailProvider = mailProvider;
        }

        @Override
        public MailProvider getMailProvider() {
            return this.mailProvider;
        }
    }

    private static final class SessionMailProviderGetter
    implements MailProviderGetter {
        private final String protocolName;

        SessionMailProviderGetter(String protocolName) {
            this.protocolName = protocolName;
        }

        @Override
        public MailProvider getMailProvider() throws OXException {
            return MailProviderRegistry.getRealMailProvider(this.protocolName);
        }
    }

    private static final class SimpleMailProviderGetter
    implements MailProviderGetter {
        private final MailProvider mailProvider;

        public SimpleMailProviderGetter(MailProvider mailProvider) {
            this.mailProvider = mailProvider;
        }

        @Override
        public MailProvider getMailProvider() {
            return this.mailProvider;
        }
    }

    private static interface MailProviderGetter {
        public MailProvider getMailProvider() throws OXException;
    }
}

