/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.preferences;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerUserSettingLoader {
    private static final ServerUserSettingLoader INSTANCE = new ServerUserSettingLoader();

    public static ServerUserSettingLoader getInstance() {
        return INSTANCE;
    }

    public Map<String, Object> loadForSafe(int userId, int contextId) {
        try {
            return this.loadFor(userId, contextId);
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(ServerUserSettingLoader.class);
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> loadFor(int userId, int contextId) throws OXException {
        ConcurrentHashMap<String, Object> concurrentHashMap;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        DatabaseService databaseService;
        block15: {
            databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
            con = databaseService.getReadOnly(contextId);
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT contact_collect_folder,contact_collect_enabled,defaultStatusPrivate,defaultStatusPublic,contactCollectOnMailAccess,contactCollectOnMailTransport,folderTree FROM user_setting_server WHERE cid=? AND user=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            if (rs.next()) break block15;
            Map<String, Object> map = null;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            databaseService.backReadOnly(contextId, con);
            return map;
        }
        try {
            ConcurrentHashMap<String, Object> newMap = new ConcurrentHashMap<String, Object>(12, 0.9f, 1);
            newMap.put("__lastAccessed", System.currentTimeMillis());
            do {
                int folderId = rs.getInt(1);
                if (!rs.wasNull()) {
                    newMap.put("contact_collect_folder", folderId);
                }
                int enabled = rs.getInt(2);
                if (rs.wasNull()) {
                    newMap.put("contact_collect_enabled", Boolean.FALSE);
                } else {
                    newMap.put("contact_collect_enabled", enabled > 0);
                }
                int defaultStatusPrivate = rs.getInt(3);
                if (!rs.wasNull()) {
                    newMap.put("defaultStatusPrivate", defaultStatusPrivate);
                }
                int defaultStatusPublic = rs.getInt(4);
                if (!rs.wasNull()) {
                    newMap.put("defaultStatusPublic", defaultStatusPublic);
                }
                int contactCollectOnMailAccess = rs.getInt(5);
                if (rs.wasNull()) {
                    newMap.put("contactCollectOnMailAccess", Boolean.FALSE);
                } else {
                    newMap.put("contactCollectOnMailAccess", contactCollectOnMailAccess > 0);
                }
                int contactCollectOnMailTransport = rs.getInt(6);
                if (rs.wasNull()) {
                    newMap.put("contactCollectOnMailTransport", Boolean.FALSE);
                } else {
                    newMap.put("contactCollectOnMailTransport", contactCollectOnMailTransport > 0);
                }
                int folderTree = rs.getInt(7);
                if (rs.wasNull()) continue;
                newMap.put("folderTree", folderTree);
            } while (rs.next());
            concurrentHashMap = newMap;
        }
        catch (SQLException e) {
            try {
                throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                databaseService.backReadOnly(contextId, con);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        databaseService.backReadOnly(contextId, con);
        return concurrentHashMap;
    }
}

