/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.passwordchange;

import com.openexchange.authentication.AuthenticationService;
import com.openexchange.authentication.BasicAuthenticationService;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.LoginInfo;
import com.openexchange.authentication.service.Authentication;
import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Strings;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.osgi.annotation.SingletonService;
import com.openexchange.passwordchange.PasswordChangeEvent;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.user.UserService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonService
public abstract class PasswordChangeService {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordChangeService.class);
    private static final Pattern PATTERN_ALLOWED_CHARS = Pattern.compile("[ $@%\\.+a-zA-Z0-9_-]+");

    protected PasswordChangeService() {
    }

    public final void perform(PasswordChangeEvent event) throws OXException {
        this.allow(event);
        this.check(event);
        this.update(event);
        this.propagate(event);
    }

    protected void allow(PasswordChangeEvent event) throws OXException {
        Context context = event.getContext();
        if (!UserConfigurationStorage.getInstance().getUserConfiguration(event.getSession().getUserId(), context).isEditPassword()) {
            throw UserExceptionCode.PERMISSION.create(context.getContextId());
        }
    }

    protected void check(PasswordChangeEvent event) throws OXException {
        User user;
        try {
            Cookie[] cookies;
            AuthenticationService authenticationService = Authentication.getService();
            if (authenticationService == null) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{AuthenticationService.class.getName()});
            }
            UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class);
            if (null == userService) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{UserService.class.getName()});
            }
            Session session = event.getSession();
            user = userService.getUser(session.getUserId(), session.getContextId());
            if (Strings.isEmpty((String)event.getOldPassword()) && !user.isGuest()) {
                throw UserExceptionCode.MISSING_CURRENT_PASSWORD.create();
            }
            if (Strings.isEmpty((String)event.getNewPassword()) && !user.isGuest()) {
                throw UserExceptionCode.MISSING_NEW_PASSWORD.create();
            }
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(2);
            Map<String, List<String>> headers = event.getHeaders();
            if (headers != null) {
                properties.put("headers", headers);
            }
            if (null != (cookies = event.getCookies())) {
                properties.put("cookies", cookies);
            }
            if (!user.isGuest()) {
                authenticationService.handleLoginInfo((LoginInfo)new _LoginInfo(session.getLogin(), event.getOldPassword(), properties));
            } else {
                BasicAuthenticationService basicService = Authentication.getBasicService();
                if (basicService == null) {
                    throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{BasicAuthenticationService.class.getName()});
                }
                basicService.handleLoginInfo(user.getId(), session.getContextId(), event.getOldPassword());
            }
        }
        catch (OXException e) {
            if (e.equalsCode(6, "LGI")) {
                throw UserExceptionCode.INCORRECT_CURRENT_PASSWORD.create(e, new Object[0]);
            }
            throw e;
        }
        if (!user.isGuest()) {
            int len = event.getNewPassword().length();
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            int property = service.getIntProperty("com.openexchange.passwordchange.minLength", 4);
            if (property > 0 && len < property) {
                throw UserExceptionCode.INVALID_MIN_LENGTH.create(property);
            }
            property = service.getIntProperty("com.openexchange.passwordchange.maxLength", 0);
            if (property > 0 && len > property) {
                throw UserExceptionCode.INVALID_MAX_LENGTH.create(property);
            }
            String allowedPattern = service.getProperty("com.openexchange.passwordchange.allowedPattern");
            if (!Strings.isEmpty((String)allowedPattern)) {
                try {
                    if (!Pattern.matches(allowedPattern, event.getNewPassword())) {
                        String allowedPatternHint = service.getProperty("com.openexchange.passwordchange.allowedPatternHint");
                        throw UserExceptionCode.NOT_ALLOWED_PASSWORD.create(allowedPatternHint);
                    }
                }
                catch (PatternSyntaxException e) {
                    throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create(e, "com.openexchange.passwordchange.allowedPattern");
                }
            }
        }
    }

    protected abstract void update(PasswordChangeEvent var1) throws OXException;

    protected void propagate(PasswordChangeEvent event) throws OXException {
        CacheService cacheService;
        Session session = event.getSession();
        MailAccess.getMailAccessCache().removeMailAccess(session, 0);
        int userId = session.getUserId();
        UserStorage.getInstance().invalidateUser(event.getContext(), userId);
        ServerServiceRegistry serviceRegistry = ServerServiceRegistry.getInstance();
        SessiondService sessiondService = serviceRegistry.getService(SessiondService.class);
        if (sessiondService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
        }
        try {
            sessiondService.changeSessionPassword(session.getSessionID(), event.getNewPassword());
        }
        catch (OXException e) {
            LOG.error("Updating password in user session failed", (Throwable)e);
            throw e;
        }
        EventAdmin eventAdmin = serviceRegistry.getService(EventAdmin.class);
        int contextId = session.getContextId();
        if (null != eventAdmin) {
            HashMap<String, Object> properties = new HashMap<String, Object>(5);
            properties.put("com.openexchange.passwordchange.contextId", contextId);
            properties.put("com.openexchange.passwordchange.userId", userId);
            properties.put("com.openexchange.passwordchange.session", session);
            properties.put("com.openexchange.passwordchange.oldPassword", event.getOldPassword());
            properties.put("com.openexchange.passwordchange.newPassword", event.getNewPassword());
            properties.put("__publishRemote", Boolean.TRUE);
            eventAdmin.postEvent(new Event("com/openexchange/passwordchange", properties));
        }
        if (null != (cacheService = serviceRegistry.getService(CacheService.class))) {
            try {
                CacheKey key = cacheService.newCacheKey(contextId, userId);
                Cache jcs = cacheService.getCache("User");
                jcs.remove((Serializable)key);
                jcs = cacheService.getCache("UserPermissionBits");
                jcs.remove((Serializable)key);
                jcs = cacheService.getCache("UserConfiguration");
                jcs.remove((Serializable)key);
                jcs = cacheService.getCache("UserSettingMail");
                jcs.remove((Serializable)key);
                jcs = cacheService.getCache("MailAccount");
                jcs.remove((Serializable)cacheService.newCacheKey(contextId, new String[]{String.valueOf(0), String.valueOf(userId)}));
                jcs.invalidateGroup(Integer.toString(contextId));
            }
            catch (OXException e) {
                // empty catch block
            }
        }
    }

    protected static final boolean validatePassword(String password) {
        return PATTERN_ALLOWED_CHARS.matcher(password).matches();
    }

    protected static final class _LoginInfo
    implements LoginInfo {
        private final String pw;
        private final String loginInfo;
        private final Map<String, Object> properties;

        public _LoginInfo(String loginInfo, String pw, Map<String, Object> properties) {
            this.loginInfo = loginInfo;
            this.pw = pw;
            this.properties = properties;
        }

        public String getPassword() {
            return this.pw;
        }

        public String getUsername() {
            return this.loginInfo;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }
}

