/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.writer.DefaultMailAccountWriter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONValue;

public final class ListAction
extends AbstractMailAccountAction {
    public static final String ACTION = "list";

    @Override
    protected AJAXRequestResult innerPerform(AJAXRequestData requestData, ServerSession session, JSONValue jData) throws OXException, JSONException {
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        List<Attribute> attributes = ListAction.getColumns(requestData.getParameter("columns"));
        JSONArray jIds = jData.toArray();
        int len = jIds.length();
        boolean multipleEnabled = session.getUserPermissionBits().isMultipleMailAccounts();
        ArrayList<MailAccount> accounts = new ArrayList<MailAccount>(len);
        int i = 0;
        int k = len;
        while (k-- > 0) {
            int id = jIds.getInt(i);
            MailAccount account = storageService.getMailAccount(id, session.getUserId(), session.getContextId());
            if (!ListAction.isUnifiedINBOXAccount(account) && (multipleEnabled || ListAction.isDefaultMailAccount(account))) {
                accounts.add(account);
            }
            ++i;
        }
        JSONArray jAccounts = DefaultMailAccountWriter.writeArray(accounts.toArray(new MailAccount[accounts.size()]), attributes, session);
        return new AJAXRequestResult(jAccounts);
    }
}

