/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.writer.DefaultMailAccountWriter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONValue;

@Action(method=RequestMethod.GET, name="all", description="Get all mail accounts", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for mail account's are defined in mail account data.")}, responseDescription="An array with attachment data. Each array element describes one mail account and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class AllAction
extends AbstractMailAccountAction {
    public static final String ACTION = "all";

    @Override
    protected AJAXRequestResult innerPerform(AJAXRequestData requestData, ServerSession session, JSONValue jVoid) throws OXException {
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        List<Attribute> attributes = AllAction.getColumns(requestData.getParameter("columns"));
        MailAccount[] userMailAccounts = storageService.getUserMailAccounts(session.getUserId(), session.getContextId());
        boolean multipleEnabled = session.getUserPermissionBits().isMultipleMailAccounts();
        ArrayList<MailAccount> tmp = new ArrayList<MailAccount>(userMailAccounts.length);
        for (MailAccount userMailAccount : userMailAccounts) {
            MailAccount mailAccount = userMailAccount;
            if (AllAction.isUnifiedINBOXAccount(mailAccount) || !multipleEnabled && !AllAction.isDefaultMailAccount(mailAccount)) continue;
            tmp.add(mailAccount);
        }
        userMailAccounts = tmp.toArray(new MailAccount[tmp.size()]);
        JSONArray jsonArray = DefaultMailAccountWriter.writeArray(userMailAccounts, attributes, session);
        return new AJAXRequestResult(jsonArray);
    }
}

