/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport.config;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.mail.api.IMailProperties;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.api.UrlInfo;
import com.openexchange.mail.config.MailConfigException;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.TransportAccount;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;

public abstract class TransportConfig
extends MailConfig {
    protected TransportConfig() {
    }

    public static final <C extends TransportConfig> C getTransportConfig(C transportConfig, Session session, int accountId) throws OXException {
        int userId = session.getUserId();
        int contextId = session.getContextId();
        MailAccountStorageService storage = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        TransportAccount transportAccount = storage.getTransportAccount(accountId, userId, contextId);
        transportConfig.accountId = accountId;
        TransportConfig.fillLoginAndPassword(transportConfig, session, UserStorage.getInstance().getUser(userId, contextId).getLoginInfo(), transportAccount);
        transportConfig.setStartTls(transportAccount.isTransportStartTls());
        UrlInfo urlInfo = TransportConfig.getTransportServerURL(transportAccount);
        String serverURL = urlInfo.getServerURL();
        if (serverURL == null) {
            if (MailConfig.ServerSource.GLOBAL.equals((Object)MailProperties.getInstance().getTransportServerSource())) {
                throw MailConfigException.create(new StringBuilder(128).append("Property \"").append("com.openexchange.mail.transportServer").append("\" not set in mail properties").toString());
            }
            throw MailConfigException.create(new StringBuilder(128).append("Cannot determine transport server URL for user ").append(userId).append(" in context ").append(contextId).toString());
        }
        int lastPos = serverURL.length() - 1;
        if (serverURL.charAt(lastPos) == '/') {
            serverURL = serverURL.substring(0, lastPos);
        }
        transportConfig.parseServerURL(urlInfo);
        transportConfig.doCustomParsing(transportAccount, session);
        return transportConfig;
    }

    public static UrlInfo getTransportServerURL(TransportAccount transportAccount) {
        if (!transportAccount.isDefaultAccount()) {
            return new UrlInfo(transportAccount.generateTransportServerURL(), transportAccount.isTransportStartTls());
        }
        if (MailConfig.ServerSource.GLOBAL.equals((Object)MailProperties.getInstance().getTransportServerSource())) {
            return new UrlInfo(MailProperties.getInstance().getTransportServer(), MailProperties.getInstance().isTransportStartTls());
        }
        return new UrlInfo(transportAccount.generateTransportServerURL(), transportAccount.isTransportStartTls());
    }

    public static UrlInfo getTransportServerURL(Session session, int accountId) throws OXException {
        MailAccountStorageService storage = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        return TransportConfig.getTransportServerURL(storage.getTransportAccount(accountId, session.getUserId(), session.getContextId()));
    }

    @Override
    public IMailProperties getMailProperties() {
        return null;
    }

    @Override
    public void setMailProperties(IMailProperties mailProperties) {
    }

    public abstract ITransportProperties getTransportProperties();

    public abstract void setTransportProperties(ITransportProperties var1);
}

