/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.osgi;

import com.openexchange.caching.CacheKey;
import com.openexchange.caching.events.CacheEvent;
import com.openexchange.caching.events.CacheEventService;
import com.openexchange.caching.events.CacheListener;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.util.Pair;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mailaccount.Tools;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailSessionCacheInvalidator
implements CacheListener,
ServiceTrackerCustomizer<CacheEventService, CacheEventService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailSessionCacheInvalidator.class);
    private static final String REGION = "MailSessionCache";
    private final BundleContext context;

    public MailSessionCacheInvalidator(BundleContext context) {
        this.context = context;
    }

    public void onEvent(Object sender, CacheEvent cacheEvent, boolean fromRemote) {
        if (fromRemote) {
            LOGGER.debug("Handling incoming remote cache event: {}", (Object)cacheEvent);
            if (REGION.equals(cacheEvent.getRegion())) {
                List keys = cacheEvent.getKeys();
                LinkedHashSet<Pair> pairs = new LinkedHashSet<Pair>(keys.size());
                for (Serializable cacheKey : keys) {
                    if (!(cacheKey instanceof CacheKey)) continue;
                    CacheKey ckey = (CacheKey)cacheKey;
                    int contextId = Tools.getUnsignedInteger(cacheEvent.getGroupName());
                    if (contextId <= 0) continue;
                    int userId = Integer.parseInt(ckey.getKeys()[0].toString());
                    if (!pairs.add(new Pair((Object)Autoboxing.I((int)contextId), (Object)Autoboxing.I((int)userId)))) continue;
                    MailSessionCache.clearFor(userId, contextId, false);
                }
            }
        }
    }

    public CacheEventService addingService(ServiceReference<CacheEventService> reference) {
        CacheEventService service = (CacheEventService)this.context.getService(reference);
        service.addListener(REGION, (CacheListener)this);
        return service;
    }

    public void modifiedService(ServiceReference<CacheEventService> reference, CacheEventService service) {
    }

    public void removedService(ServiceReference<CacheEventService> reference, CacheEventService service) {
        service.removeListener(REGION, (CacheListener)this);
        this.context.ungetService(reference);
    }
}

