/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.utils.MessageUtility;
import com.sun.mail.util.MessageRemovedIOException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public final class MimeSmilFixer {
    private static final MimeSmilFixer INSTANCE = new MimeSmilFixer();
    private static final String CONTENT_TRANSFER_ENC = MessageHeaders.HDR_CONTENT_TRANSFER_ENC;
    private static final String MIME_VERSION = MessageHeaders.HDR_MIME_VERSION;
    private static final String CONTENT_DISPOSITION = MessageHeaders.HDR_CONTENT_DISPOSITION;
    private static final String CONTENT_TYPE = MessageHeaders.HDR_CONTENT_TYPE;
    private static final String MESSAGE_ID = MessageHeaders.HDR_MESSAGE_ID;
    private static final String[] HEADER_NAMES = new String[]{"Content-Description", "Content-Location", "Content-Disposition", "Content-ID"};
    private static final Pattern PATTERN_BODY_START = Pattern.compile("<body[^>]*?>", 2);
    private static final Pattern PATTERN_BODY_END = Pattern.compile("</body>", 2);

    public static MimeSmilFixer getInstance() {
        return INSTANCE;
    }

    private MimeSmilFixer() {
    }

    public MailMessage process(MailMessage message) throws OXException {
        if (null == message) {
            return message;
        }
        ContentType contentType = message.getContentType();
        if (!contentType.startsWith("multipart/")) {
            return message;
        }
        MimeMessage mimeMessage = (MimeMessage)MimeMessageConverter.convertMailMessage(message);
        MimeMessage processed = this.process0(mimeMessage, contentType);
        MailMessage processedMessage = MimeMessageConverter.convertMessage(processed, true);
        processedMessage.setMailId(message.getMailId());
        if (message.containsReceivedDate()) {
            processedMessage.setReceivedDate(message.getReceivedDate());
        }
        if (!processedMessage.containsSize() && message.containsSize()) {
            processedMessage.setSize(message.getSize());
        }
        if (message.containsAccountId()) {
            processedMessage.setAccountId(message.getAccountId());
        }
        if (message.containsFolder()) {
            processedMessage.setFolder(message.getFolder());
        }
        if (message.containsFlags()) {
            processedMessage.setFlags(message.getFlags());
        }
        if (message.containsColorLabel()) {
            processedMessage.setColorLabel(message.getColorLabel());
        }
        if (message.containsUserFlags()) {
            processedMessage.addUserFlags(message.getUserFlags());
        }
        return processedMessage;
    }

    public MimeMessage process(MimeMessage mimeMessage) throws OXException {
        if (null == mimeMessage) {
            return mimeMessage;
        }
        ContentType contentType = this.getContentType((Part)mimeMessage);
        if (!contentType.startsWith("multipart/")) {
            return mimeMessage;
        }
        return this.process0(mimeMessage, contentType);
    }

    private MimeMessage process0(MimeMessage mimeMessage, ContentType contentType) throws OXException {
        try {
            String messageId = mimeMessage.getHeader(MESSAGE_ID, null);
            AtomicReference<MimeMultipart> multipartRef = new AtomicReference<MimeMultipart>(new MimeMultipart(contentType.getSubType()));
            this.handlePart(MimeMessageConverter.multipartFor(mimeMessage, contentType), multipartRef);
            MessageUtility.setContent((Multipart)multipartRef.get(), (Part)mimeMessage);
            MimeMessageConverter.saveChanges(mimeMessage);
            if (null == messageId) {
                mimeMessage.removeHeader(MESSAGE_ID);
            } else {
                mimeMessage.setHeader(MESSAGE_ID, messageId);
            }
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (MessageRemovedIOException e) {
            throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create();
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private void handlePart(Multipart multipart, AtomicReference<MimeMultipart> newMultipartRef) throws MessagingException, IOException, OXException {
        int count = multipart.getCount();
        ContentType mpContentType = new ContentType(multipart.getContentType());
        if (mpContentType.startsWith("multipart/related") && "application/smil".equals(mpContentType.getParameter(Strings.toLowerCase((CharSequence)"type")))) {
            MimeMultipart mixedMultipart = new MimeMultipart("mixed");
            for (int i = 0; i < count; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                ContentType contentType = this.getContentType((Part)bodyPart);
                if (contentType.startsWith("application/smil")) continue;
                if (contentType.startsWith("text/")) {
                    MimeBodyPart textBodyPart = new MimeBodyPart();
                    textBodyPart.setDataHandler(new DataHandler((DataSource)new MimePartDataSource((MimePart)bodyPart)));
                    Enumeration en = bodyPart.getNonMatchingHeaders(HEADER_NAMES);
                    while (en.hasMoreElements()) {
                        Header header = (Header)en.nextElement();
                        textBodyPart.addHeader(header.getName(), header.getValue());
                    }
                    contentType.removeParameter("name");
                    textBodyPart.setHeader(CONTENT_TYPE, contentType.toString());
                    mixedMultipart.addBodyPart((BodyPart)textBodyPart);
                    continue;
                }
                mixedMultipart.addBodyPart(bodyPart);
            }
            newMultipartRef.set(mixedMultipart);
            return;
        }
        MimeMultipart newMimeMultipart = newMultipartRef.get();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            String sContentType = bodyPart.getContentType();
            if (MimeSmilFixer.isEmpty(sContentType)) {
                newMimeMultipart.addBodyPart(bodyPart);
                continue;
            }
            ContentType contentType = new ContentType(sContentType);
            if (contentType.startsWith("multipart/")) {
                MimeMultipart newMimeMultipart2 = new MimeMultipart(contentType.getSubType());
                AtomicReference<MimeMultipart> mpReference = new AtomicReference<MimeMultipart>(newMimeMultipart2);
                Object content = bodyPart.getContent();
                Object mpContent = content instanceof Multipart ? (Multipart)content : new MimeMultipart(bodyPart.getDataHandler().getDataSource());
                this.handlePart((Multipart)mpContent, mpReference);
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                MessageUtility.setContent((Multipart)mpReference.get(), (Part)mimeBodyPart);
                newMimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                continue;
            }
            if (contentType.startsWith("message/rfc822") || contentType.getNameParameter() != null && contentType.getNameParameter().endsWith(".eml")) {
                Object content = bodyPart.getContent();
                MimeMessage filteredMessage = content instanceof MimeMessage ? this.process((MimeMessage)content) : this.process(new MimeMessage(MimeDefaultSession.getDefaultSession(), bodyPart.getInputStream()));
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                MessageUtility.setContent((Message)filteredMessage, (Part)mimeBodyPart);
                newMimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                continue;
            }
            newMimeMultipart.addBodyPart(bodyPart);
        }
    }

    private String mergeInto(String anotherHtml, String mainHtml) {
        Matcher mStart = PATTERN_BODY_START.matcher(anotherHtml);
        Matcher mEnd = PATTERN_BODY_END.matcher(anotherHtml);
        if (!mStart.find() || !mEnd.find()) {
            Matcher mMain = PATTERN_BODY_END.matcher(mainHtml);
            if (mMain.find()) {
                StringBuffer sb = new StringBuffer(mainHtml.length() + anotherHtml.length());
                mMain.appendReplacement(sb, Matcher.quoteReplacement(anotherHtml) + Matcher.quoteReplacement(mMain.group()));
                mMain.appendTail(sb);
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder(mainHtml.length() + anotherHtml.length());
            sb.append(mainHtml).append(anotherHtml);
            return sb.toString();
        }
        Matcher mMain = PATTERN_BODY_END.matcher(mainHtml);
        if (mMain.find()) {
            StringBuffer sb = new StringBuffer(mainHtml.length() + anotherHtml.length());
            mMain.appendReplacement(sb, Matcher.quoteReplacement(anotherHtml.substring(mStart.end(), mEnd.start())) + Matcher.quoteReplacement(mMain.group()));
            mMain.appendTail(sb);
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(mainHtml.length() + anotherHtml.length());
        sb.append(mainHtml).append(anotherHtml.substring(mStart.end(), mEnd.start()));
        return sb.toString();
    }

    private ContentType getContentType(Part part) throws OXException {
        try {
            String[] tmp = part.getHeader(CONTENT_TYPE);
            return tmp != null && tmp.length > 0 ? new ContentType(tmp[0]) : new ContentType("text/plain; charset=us-ascii");
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private String getContentId(String sContentId) {
        if (null == sContentId) {
            return null;
        }
        if (sContentId.startsWith("<") && sContentId.endsWith(">")) {
            return sContentId.substring(1, sContentId.length() - 1);
        }
        return sContentId;
    }

    private static boolean isInline(Part part, ContentType contentType) throws OXException {
        try {
            boolean hasDisposition;
            ContentDisposition cd;
            String[] hdr = part.getHeader(CONTENT_DISPOSITION);
            if (null == hdr) {
                cd = new ContentDisposition();
                hasDisposition = false;
            } else {
                cd = new ContentDisposition(hdr[0]);
                hasDisposition = true;
            }
            return hasDisposition && "inline".equalsIgnoreCase(cd.getDisposition()) || !hasDisposition && !cd.containsFilenameParameter() && !contentType.containsParameter("name");
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        block3: for (int i = 0; isWhitespace && i < len; ++i) {
            switch (string.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': {
                    isWhitespace = true;
                    continue block3;
                }
                default: {
                    isWhitespace = false;
                }
            }
        }
        return isWhitespace;
    }
}

