/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.compose.share;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.DefaultFileStorageFolder;
import com.openexchange.file.storage.DefaultFileStorageGuestPermission;
import com.openexchange.file.storage.DefaultFileStoragePermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.composition.FilenameValidationUtils;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.folderstorage.Permissions;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.json.compose.ComposeContext;
import com.openexchange.mail.json.compose.ComposeRequest;
import com.openexchange.mail.json.compose.Utilities;
import com.openexchange.mail.json.compose.share.DefaultAttachmentStoragePeriodicCleaner;
import com.openexchange.mail.json.compose.share.DefaultStoredAttachmentsControl;
import com.openexchange.mail.json.compose.share.Item;
import com.openexchange.mail.json.compose.share.StoredAttachmentsControl;
import com.openexchange.mail.json.compose.share.spi.AttachmentStorage;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.share.ShareTarget;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.share.recipient.ShareRecipient;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tx.TransactionAware;
import com.openexchange.tx.TransactionAwares;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultAttachmentStorage
implements AttachmentStorage {
    private static volatile DefaultAttachmentStorage instance;
    private final String id;
    private volatile ScheduledTimerTask timerTask;
    private volatile DefaultAttachmentStoragePeriodicCleaner cleaner;

    public static DefaultAttachmentStorage getInstance() {
        return instance;
    }

    public static synchronized void startInstance(ConfigurationService configService, TimerService timerService) throws OXException {
        DefaultAttachmentStorage tmp = instance;
        if (null == tmp) {
            tmp = new DefaultAttachmentStorage("default");
            long cleanerInterval = Utilities.parseTimespanProperty("com.openexchange.mail.compose.share.periodicCleanerInterval", TimeUnit.DAYS.toMillis(1L), TimeUnit.HOURS.toMillis(1L), true, configService);
            if (0L < cleanerInterval) {
                DefaultAttachmentStoragePeriodicCleaner cleaner = new DefaultAttachmentStoragePeriodicCleaner(tmp.id);
                long shiftMillis = TimeUnit.MILLISECONDS.convert((long)(Math.random() * 100.0), TimeUnit.MINUTES);
                ScheduledTimerTask timerTask = timerService.scheduleWithFixedDelay((Runnable)cleaner, cleanerInterval + shiftMillis, cleanerInterval);
                tmp.setCleanerInfo(cleaner, timerTask);
            }
            instance = tmp;
        }
    }

    public static synchronized void shutDown() {
        DefaultAttachmentStorage tmp = instance;
        if (null != tmp) {
            instance = null;
            tmp.halt();
        }
    }

    protected DefaultAttachmentStorage(String id) {
        this.id = id;
        this.timerTask = this.timerTask;
    }

    private void setCleanerInfo(DefaultAttachmentStoragePeriodicCleaner cleaner, ScheduledTimerTask timerTask) {
        this.cleaner = cleaner;
        this.timerTask = timerTask;
    }

    private void halt() {
        ScheduledTimerTask timerTask;
        DefaultAttachmentStoragePeriodicCleaner cleaner = this.cleaner;
        if (null != cleaner) {
            this.cleaner = null;
            cleaner.stop();
        }
        if (null != (timerTask = this.timerTask)) {
            this.timerTask = null;
            timerTask.cancel(true);
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean applicableFor(ComposeRequest composeRequest) throws OXException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredAttachmentsControl storeAttachments(ComposedMailMessage sourceMessage, String password, Date expiry, boolean autoDelete, ComposeContext context) throws OXException {
        ServerSession session = context.getSession();
        DefaultAttachmentStorageContext storageContext = new DefaultAttachmentStorageContext(this.getFileAccess(session), this.getFolderAccess(session), session);
        boolean rollback = false;
        try {
            storageContext.startTransaction();
            rollback = true;
            Locale locale = session.getUser().getLocale();
            Item folder = this.createFolder(sourceMessage, password, expiry, autoDelete, locale, storageContext);
            List<Item> files = this.saveAttachments(context.getAllParts(), folder, autoDelete ? expiry : null, locale, storageContext);
            ShareTarget folderTarget = new ShareTarget(FileStorageContentType.getInstance().getModule(), folder.getId());
            DefaultStoredAttachmentsControl attachmentsControl = new DefaultStoredAttachmentsControl(files, folder, folderTarget, storageContext);
            rollback = false;
            DefaultStoredAttachmentsControl defaultStoredAttachmentsControl = attachmentsControl;
            return defaultStoredAttachmentsControl;
        }
        finally {
            if (rollback) {
                DefaultAttachmentStorage.rollback(storageContext);
            }
        }
    }

    protected IDBasedFolderAccess getFolderAccess(Session session) throws OXException {
        IDBasedFolderAccessFactory factory = ServerServiceRegistry.getServize(IDBasedFolderAccessFactory.class);
        if (null == factory) {
            throw ServiceExceptionCode.absentService(IDBasedFolderAccessFactory.class);
        }
        return factory.createAccess(session);
    }

    protected IDBasedFileAccess getFileAccess(Session session) throws OXException {
        IDBasedFileAccessFactory factory = ServerServiceRegistry.getServize(IDBasedFileAccessFactory.class);
        if (null == factory) {
            throw ServiceExceptionCode.absentService(IDBasedFileAccessFactory.class);
        }
        return factory.createAccess(session);
    }

    protected List<Item> saveAttachments(List<MailPart> attachments2, Item folder, Date expiry, Locale locale, DefaultAttachmentStorageContext storageContext) throws OXException {
        ArrayList<Item> createdFiles = new ArrayList<Item>(attachments2.size());
        for (MailPart attachment : attachments2) {
            createdFiles.add(this.saveAttachment(attachment, folder, expiry, locale, storageContext));
        }
        return createdFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Item saveAttachment(MailPart attachment, Item folder, Date expiry, Locale locale, DefaultAttachmentStorageContext storageContext) throws OXException {
        File file = this.prepareMetadata(attachment, folder, expiry, locale);
        InputStream inputStream = null;
        try {
            inputStream = attachment.getInputStream();
            Item item = new Item(storageContext.fileAccess.saveDocument(file, inputStream, -1L), file.getFileName());
            return item;
        }
        finally {
            Streams.close((Closeable)inputStream);
        }
    }

    protected File prepareMetadata(MailPart attachment, Item folder, Date expiry, Locale locale) {
        String name = this.sanitizeName(attachment.getFileName(), StringHelper.valueOf(locale).getString("File"));
        DefaultFile file = new DefaultFile();
        file.setId(FileStorageFileAccess.NEW);
        file.setFolderId(folder.getId());
        file.setFileName(name);
        file.setFileMIMEType(attachment.getContentType().getBaseType());
        file.setTitle(name);
        file.setFileSize(attachment.getSize());
        if (null != expiry) {
            file.setMeta(DefaultAttachmentStorage.mapFor("expiration-date-" + this.getId(), expiry.getTime()));
        }
        return file;
    }

    protected String sanitizeName(String name, String defaultName) {
        String toSanitize = name;
        if (Strings.isEmpty((String)toSanitize)) {
            toSanitize = defaultName;
        } else {
            toSanitize = toSanitize.trim();
            boolean sanitize = true;
            while (sanitize) {
                sanitize = false;
                String illegalCharacters = FilenameValidationUtils.getIllegalCharacters((String)toSanitize);
                if (illegalCharacters != null) {
                    int length;
                    sanitize = true;
                    int i = length = illegalCharacters.length();
                    while (i-- > 0) {
                        toSanitize = toSanitize.replace(illegalCharacters.charAt(i), '_');
                    }
                    continue;
                }
                FilenameValidationUtils.ValidityResult validity = FilenameValidationUtils.getValidityFor((String)toSanitize);
                if (validity.isValid()) continue;
                sanitize = true;
                toSanitize = defaultName;
            }
        }
        return toSanitize;
    }

    protected Context getContext(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getContext();
        }
        return ContextStorage.getStorageContext(session.getContextId());
    }

    protected User getSessionUser(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser();
        }
        return UserStorage.getInstance().getUser(session.getUserId(), this.getContext(session));
    }

    protected Locale getSessionUserLocale(Session session) throws OXException {
        return this.getSessionUser(session).getLocale();
    }

    protected Item createFolder(ComposedMailMessage source, String password, Date expiry, boolean autoDelete, Locale locale, DefaultAttachmentStorageContext storageContext) throws OXException {
        String parentFolderID;
        Session session = storageContext.session;
        String paramterName = MailSessionParameterNames.getParamSharingDriveFolderID();
        Object parameter = session.getParameter(paramterName);
        if (null != parameter) {
            parentFolderID = String.valueOf(parameter);
        } else {
            parentFolderID = this.discoverEMailAttachmentsFolderID(storageContext);
            session.setParameter(paramterName, (Object)parentFolderID);
        }
        DefaultFileStorageFolder folder = this.prepareFolder(source, parentFolderID, password, expiry, autoDelete, session, locale);
        IDBasedFolderAccess folderAccess = storageContext.folderAccess;
        int counter = 1;
        while (true) {
            try {
                return new Item(folderAccess.createFolder((FileStorageFolder)folder), folder.getName());
            }
            catch (OXException e) {
                if (e.equalsCode(1014, "FLD") || e.equalsCode(12, "FLD")) {
                    folder.setName(FileStorageUtility.enhance((String)folder.getName(), (int)counter++));
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    protected String discoverEMailAttachmentsFolderID(DefaultAttachmentStorageContext storageContext) throws OXException {
        FolderID placeholderID;
        FileStorageFolder personalFolder;
        IDBasedFolderAccess folderAccess;
        FileStorageFolder[] subfolders;
        Session session = storageContext.session;
        Locale locale = this.getSessionUserLocale(session);
        String name = Utilities.getValueFromProperty("com.openexchange.mail.compose.share.folderName." + locale.getLanguage() + "_" + locale.getCountry(), null, session);
        if (Strings.isEmpty((String)name) && "i18n-defined".equalsIgnoreCase(name = Utilities.getValueFromProperty("com.openexchange.mail.compose.share.folderName", "i18n-defined", session))) {
            name = StringHelper.valueOf(locale).getString("My shared mail attachments");
        }
        if (null != (subfolders = (folderAccess = storageContext.folderAccess).getSubfolders((personalFolder = folderAccess.getPersonalFolder((placeholderID = new FolderID("com.openexchange.infostore", "infostore", "0")).toString())).getId(), true)) && 0 < subfolders.length) {
            for (FileStorageFolder subfolder : subfolders) {
                if (!name.equals(subfolder.getName())) continue;
                if (null != subfolder.getOwnPermission() && 8 > subfolder.getOwnPermission().getFolderPermission()) {
                    throw FileStorageExceptionCodes.NO_CREATE_ACCESS.create(new Object[]{subfolder.getName()});
                }
                return subfolder.getId();
            }
        }
        DefaultFileStorageFolder folder = new DefaultFileStorageFolder();
        folder.setName(name);
        DefaultFileStoragePermission permission = DefaultFileStoragePermission.newInstance();
        permission.setEntity(session.getUserId());
        folder.setPermissions(Collections.singletonList(permission));
        folder.setParentId(personalFolder.getId());
        return folderAccess.createFolder((FileStorageFolder)folder);
    }

    protected DefaultFileStorageFolder prepareFolder(ComposedMailMessage source, String parentId, String password, Date expiry, boolean autoDelete, Session session, Locale locale) {
        DefaultFileStorageFolder folder = new DefaultFileStorageFolder();
        folder.setParentId(parentId);
        folder.setName(this.sanitizeName(source.getSubject(), StringHelper.valueOf(locale).getString("Folder")));
        ArrayList<Object> permissions = new ArrayList<Object>(2);
        DefaultFileStoragePermission userPermission = DefaultFileStoragePermission.newInstance();
        userPermission.setMaxPermissions();
        userPermission.setEntity(session.getUserId());
        permissions.add(userPermission);
        DefaultFileStorageGuestPermission guestPermission = new DefaultFileStorageGuestPermission(DefaultAttachmentStorage.prepareRecipient(password, expiry));
        guestPermission.setAllPermissions(2, 4, 0, 0);
        permissions.add(guestPermission);
        folder.setPermissions(permissions);
        if (autoDelete && null != expiry) {
            folder.setMeta(DefaultAttachmentStorage.mapFor("expiration-date-" + this.getId(), expiry.getTime()));
        }
        this.setAdditionalInfos(folder);
        return folder;
    }

    protected void setAdditionalInfos(DefaultFileStorageFolder folder) {
    }

    private static ShareRecipient prepareRecipient(String password, Date expiryDate) {
        return new AnonymousRecipient(Permissions.createReadOnlyPermissionBits(), password, expiryDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rollback(DefaultAttachmentStorageContext storageContext) throws OXException {
        if (null != storageContext) {
            try {
                storageContext.rollback();
            }
            finally {
                TransactionAwares.finishSafe((TransactionAware)storageContext);
            }
        }
    }

    protected static Map<String, Object> mapFor(Object ... args) {
        if (null == args) {
            return null;
        }
        int length = args.length;
        if (0 == length || length % 2 != 0) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(length >> 1);
        for (int i = 0; i < length; i += 2) {
            map.put(args[i].toString(), args[i + 1]);
        }
        return map;
    }

    protected static class DefaultAttachmentStorageContext
    implements TransactionAware {
        final IDBasedFolderAccess folderAccess;
        final IDBasedFileAccess fileAccess;
        final Session session;

        protected DefaultAttachmentStorageContext(IDBasedFileAccess fileAccess, IDBasedFolderAccess folderAccess, Session session) {
            this.fileAccess = fileAccess;
            this.folderAccess = folderAccess;
            this.session = session;
        }

        public void startTransaction() throws OXException {
            this.folderAccess.startTransaction();
            this.fileAccess.startTransaction();
        }

        public void commit() throws OXException {
            this.fileAccess.commit();
            this.folderAccess.commit();
        }

        public void rollback() throws OXException {
            this.fileAccess.rollback();
            this.folderAccess.rollback();
        }

        public void finish() throws OXException {
            this.fileAccess.finish();
            this.folderAccess.finish();
        }

        public void setTransactional(boolean transactional) {
        }

        public void setRequestTransactional(boolean transactional) {
        }

        public void setCommitsTransaction(boolean commits) {
        }
    }
}

