/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractArchiveMailAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="archive", description="Moves mails to archive folder", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested mail."), @Parameter(name="folder", description="Object ID of the source folder.")}, requestBody="A JSON object containing the id of the destination folder inside the \"folder_id\" field: e.g.: {\"folder_id\": 1376}.", responseDescription="A JSON true response.")
public final class ArchiveAction
extends AbstractArchiveMailAction {
    public ArchiveAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult performArchive(MailRequest req) throws OXException {
        try {
            ServerSession session = req.getSession();
            String folderId = req.getParameter("folder");
            boolean useDefaultName = AJAXRequestDataTools.parseBoolParameter("useDefaultName", req.getRequest(), true);
            boolean createIfAbsent = AJAXRequestDataTools.parseBoolParameter("createIfAbsent", req.getRequest(), true);
            JSONArray jArray = (JSONArray)req.getRequest().getData();
            if (null == jArray) {
                throw AjaxExceptionCodes.MISSING_REQUEST_BODY.create();
            }
            int length = jArray.length();
            if (folderId == null) {
                ArrayList<String[]> paraList = new ArrayList<String[]>(length);
                for (int i = 0; i < length; ++i) {
                    JSONObject jObject = jArray.getJSONObject(i);
                    String folder = jObject.getString("folder");
                    String id = jObject.getString("id");
                    paraList.add(new String[]{folder, id});
                }
                MailServletInterface mailInterface = this.getMailInterface(req);
                List<AbstractArchiveMailAction.ArchiveDataWrapper> retval = mailInterface.archiveMultipleMail(paraList, session, useDefaultName, createIfAbsent);
                if (retval == null) {
                    return new AJAXRequestResult((Object)Boolean.TRUE, "native");
                }
                JSONArray json = new JSONArray();
                for (AbstractArchiveMailAction.ArchiveDataWrapper obj : retval) {
                    JSONObject tmp = new JSONObject();
                    tmp.put("id", (Object)obj.getId());
                    tmp.put("created", obj.isCreated());
                    json.put((Object)tmp);
                }
                return new AJAXRequestResult((Object)json, "json");
            }
            ArrayList<String> ids = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                ids.add(jArray.getString(i));
            }
            MailServletInterface mailInterface = this.getMailInterface(req);
            List<AbstractArchiveMailAction.ArchiveDataWrapper> retval = mailInterface.archiveMail(folderId, ids, session, useDefaultName, createIfAbsent);
            if (retval == null) {
                return new AJAXRequestResult((Object)Boolean.TRUE, "native");
            }
            JSONArray json = new JSONArray();
            for (AbstractArchiveMailAction.ArchiveDataWrapper obj : retval) {
                JSONObject tmp = new JSONObject();
                tmp.put("id", (Object)obj.getId());
                tmp.put("created", obj.isCreated());
                json.put((Object)tmp);
            }
            return new AJAXRequestResult((Object)json, "json");
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }
}

