/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.mime.datasource.FileHolderDataSource;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.session.Session;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReferencedMailPart
extends MailPart
implements ComposedMailPart {
    private static final long serialVersionUID = 1097727980840011436L;
    private static final transient Logger LOG = LoggerFactory.getLogger(ReferencedMailPart.class);
    protected static final int DEFAULT_BUF_SIZE = 8192;
    private static final int MB = 0x100000;
    private final boolean isMail;
    private final ThresholdFileHolder file;
    private transient DataSource dataSource;
    private transient Object cachedContent;
    private static final String TEXT = "text/";

    protected ReferencedMailPart(MailPart referencedPart, Session session) throws OXException {
        ThresholdFileHolder sink;
        this.isMail = referencedPart.getContentType().isMimeType("message/rfc822") && !referencedPart.getContentDisposition().isAttachment();
        int partLimit = TransportProperties.getInstance().getReferencedPartLimit();
        this.file = sink = partLimit <= 0 ? new ThresholdFileHolder() : new ThresholdFileHolder(partLimit);
        this.handleReferencedPart(referencedPart, sink);
    }

    protected ReferencedMailPart(MailMessage referencedMail, Session session) throws OXException {
        ThresholdFileHolder sink;
        this.isMail = true;
        int partLimit = TransportProperties.getInstance().getReferencedPartLimit();
        this.file = sink = partLimit <= 0 ? new ThresholdFileHolder() : new ThresholdFileHolder(partLimit);
        this.handleReferencedPart(referencedMail, sink);
    }

    private void handleReferencedPart(MailPart referencedPart, ThresholdFileHolder file) throws OXException {
        if (this.isMail) {
            file.write(this.messageSource(referencedPart));
            this.setContentType("message/rfc822");
            this.setContentDisposition("inline");
            this.setSize(file.getLength());
        } else {
            file.write(referencedPart.getInputStream());
            this.setHeaders(referencedPart);
        }
        if (!this.containsFileName() && referencedPart.containsFileName()) {
            this.setFileName(referencedPart.getFileName());
        }
    }

    private InputStream messageSource(MailPart referencedPart) throws OXException {
        if (referencedPart instanceof MailMessage) {
            return MimeMessageUtility.getStreamFromMailPart(referencedPart);
        }
        return referencedPart.getInputStream();
    }

    private void setHeaders(MailPart referencedPart) {
        if (referencedPart.containsContentId()) {
            this.setContentId(referencedPart.getContentId());
        }
        this.setContentType(referencedPart.getContentType());
        this.setContentDisposition(referencedPart.getContentDisposition());
        this.setFileName(referencedPart.getFileName());
        if (!this.containsSize()) {
            this.setSize(referencedPart.getSize());
        }
        int count = referencedPart.getHeadersSize();
        Iterator<Map.Entry<String, String>> iter = referencedPart.getHeadersIterator();
        for (int i = 0; i < count; ++i) {
            Map.Entry<String, String> e = iter.next();
            this.addHeader(e.getKey(), e.getValue());
        }
    }

    private DataSource getDataSource() {
        if (null == this.dataSource) {
            if (this.getContentType().startsWith(TEXT) && this.getContentType().getCharsetParameter() == null) {
                if (this.file.isInMemory()) {
                    this.getContentType().setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
                } else {
                    this.getContentType().setCharsetParameter(System.getProperty("file.encoding", MailProperties.getInstance().getDefaultMimeCharset()));
                }
            }
            this.dataSource = new FileHolderDataSource(this.file, this.getContentType().toString());
        }
        return this.dataSource;
    }

    @Override
    public Object getContent() throws OXException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        if (this.getContentType().isMimeType("text/*")) {
            this.cachedContent = this.file.isInMemory() ? this.getByteContent(this.file.getBuffer()) : this.getFileContent(this.file.getTempFile());
            return this.cachedContent;
        }
        return null;
    }

    private String getFileContent(File file) throws OXException {
        String string;
        String charset = this.getContentType().getCharsetParameter();
        if (null == charset) {
            charset = System.getProperty("file.encoding", MailProperties.getInstance().getDefaultMimeCharset());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            string = MessageUtility.readStream(fis, charset);
        }
        catch (IOException e) {
            try {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Streams.close(fis);
                throw throwable;
            }
        }
        Streams.close((Closeable)fis);
        return string;
    }

    private String getByteContent(ByteArrayOutputStream buf) throws OXException {
        String charset = this.getContentType().getCharsetParameter();
        if (null == charset) {
            charset = MailProperties.getInstance().getDefaultMimeCharset();
        }
        try {
            return new String(buf.toByteArray(), Charsets.forName((String)charset));
        }
        catch (UnsupportedCharsetException e) {
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler(this.getDataSource());
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        return this.file.getStream();
    }

    @Override
    public void loadContent() {
        LOG.trace("ReferencedMailPart.loadContent()");
    }

    @Override
    public void prepareForCaching() {
        LOG.trace("ReferencedMailPart.prepareForCaching()");
    }

    public void close() {
        ThresholdFileHolder sink = this.file;
        if (null != sink) {
            sink.close();
        }
    }

    public boolean isMail() {
        return this.isMail;
    }

    @Override
    public ComposedMailPart.ComposedPartType getType() {
        return ComposedMailPart.ComposedPartType.REFERENCE;
    }
}

