/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.datasource.FileHolderDataSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.session.Session;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataMailPart
extends MailPart
implements ComposedMailPart {
    private static final long serialVersionUID = -2377505617785953620L;
    private static final int DEFAULT_BUF_SIZE = 8192;
    private static final transient Logger LOG = LoggerFactory.getLogger(DataMailPart.class);
    private static final int MB = 0x100000;
    private final ThresholdFileHolder file;
    private final byte[] bytes;
    private transient Object cachedContent;
    private transient DataSource dataSource;
    private static final String TEXT = "text/";

    protected DataMailPart(Object data, Map<String, String> dataProperties, Session session) throws OXException {
        this.setHeaders(dataProperties);
        if (data instanceof InputStream) {
            ThresholdFileHolder sink;
            this.bytes = null;
            int partLimit = TransportProperties.getInstance().getReferencedPartLimit();
            this.file = sink = partLimit <= 0 ? new ThresholdFileHolder() : new ThresholdFileHolder(partLimit);
            sink.write((InputStream)data);
            this.setSize(sink.getLength());
        } else if (data instanceof byte[]) {
            this.file = null;
            this.bytes = (byte[])data;
            this.setSize(this.bytes.length);
        } else {
            throw MailExceptionCode.UNSUPPORTED_DATASOURCE.create();
        }
    }

    @Override
    public Object getContent() throws OXException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        if (this.getContentType().isMimeType("text/*")) {
            this.cachedContent = this.bytes != null ? this.getByteContent(this.bytes) : (this.file.isInMemory() ? this.getByteContent(this.file.getBuffer().toByteArray()) : this.getFileContent(this.file.getTempFile()));
            return this.cachedContent;
        }
        return null;
    }

    private String getFileContent(File file) throws OXException {
        String string;
        String charset = this.getContentType().getCharsetParameter();
        if (null == charset) {
            charset = System.getProperty("file.encoding", MailProperties.getInstance().getDefaultMimeCharset());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            string = MessageUtility.readStream(fis, charset);
        }
        catch (IOException e) {
            try {
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Streams.close(fis);
                throw throwable;
            }
        }
        Streams.close((Closeable)fis);
        return string;
    }

    private String getByteContent(byte[] bytes) throws OXException {
        String charset = this.getContentType().getCharsetParameter();
        if (null == charset) {
            charset = MailProperties.getInstance().getDefaultMimeCharset();
        }
        try {
            return new String(bytes, Charsets.forName((String)charset));
        }
        catch (UnsupportedCharsetException e) {
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler(this.getDataSource());
    }

    private DataSource getDataSource() throws OXException {
        if (null == this.dataSource) {
            ContentType contentType = this.getContentType();
            if (this.bytes != null) {
                if (contentType.startsWith(TEXT) && !contentType.containsCharsetParameter()) {
                    contentType.setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
                }
                this.dataSource = new MessageDataSource(this.bytes, contentType.toString());
                return this.dataSource;
            }
            if (this.file != null) {
                if (this.getContentType().startsWith(TEXT) && this.getContentType().getCharsetParameter() == null) {
                    if (this.file.isInMemory()) {
                        this.getContentType().setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
                    } else {
                        this.getContentType().setCharsetParameter(System.getProperty("file.encoding", MailProperties.getInstance().getDefaultMimeCharset()));
                    }
                }
                this.dataSource = new FileHolderDataSource(this.file, this.getContentType().toString());
            } else {
                throw MailExceptionCode.NO_CONTENT.create();
            }
        }
        return this.dataSource;
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        if (this.bytes != null) {
            return Streams.newByteArrayInputStream((byte[])this.bytes);
        }
        if (this.file != null) {
            return this.file.getStream();
        }
        throw MailExceptionCode.NO_CONTENT.create();
    }

    @Override
    public ComposedMailPart.ComposedPartType getType() {
        return ComposedMailPart.ComposedPartType.DATA;
    }

    @Override
    public void loadContent() throws OXException {
        LOG.trace("DataSourceMailPart.loadContent()");
    }

    @Override
    public void prepareForCaching() {
        LOG.trace("DataSourceMailPart.prepareForCaching()");
    }

    public void close() {
        ThresholdFileHolder sink = this.file;
        if (null != sink) {
            sink.close();
        }
    }

    private void setHeaders(Map<String, String> dataProperties) throws OXException {
        String disp;
        ContentType contentType;
        String charset;
        String cts = dataProperties.get("com.openexchange.conversion.content-type");
        if (null != cts) {
            this.setContentType(cts);
        }
        if (null != (charset = dataProperties.get("com.openexchange.conversion.charset")) && (contentType = this.getContentType()).startsWith(TEXT)) {
            contentType.setCharsetParameter(charset);
        }
        if (null == (disp = dataProperties.get("com.openexchange.conversion.disposition"))) {
            this.getContentDisposition().setDisposition("attachment");
        } else {
            this.getContentDisposition().setDisposition(disp);
        }
        String fileName = dataProperties.get("com.openexchange.conversion.name");
        if (null != fileName) {
            this.getContentType().setNameParameter(fileName);
            this.getContentDisposition().setFilenameParameter(fileName);
        }
    }
}

