/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api;

import com.openexchange.exception.OXException;
import com.openexchange.mail.Protocol;
import com.openexchange.mail.api.AbstractProtocolProperties;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.permission.DefaultMailPermission;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.session.Session;
import com.openexchange.spamhandler.SpamHandler;
import com.openexchange.spamhandler.SpamHandlerRegistry;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;

public abstract class MailProvider {
    private boolean deprecated;
    private final AtomicBoolean startupFlag = new AtomicBoolean();

    protected MailProvider() {
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MailProvider)) {
            return false;
        }
        Protocol thisProtocol = this.getProtocol();
        Protocol otherProtocol = ((MailProvider)obj).getProtocol();
        return !(thisProtocol == null ? otherProtocol != null : !thisProtocol.equals(otherProtocol));
    }

    public final int hashCode() {
        return this.getProtocol().hashCode();
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public void startUp() throws OXException {
        if (!this.startupFlag.compareAndSet(false, true)) {
            return;
        }
        this.getProtocolProps().loadProperties();
        MailAccess<?, ?> access = this.createNewMailAccess(null);
        if (null != access) {
            MailAccess.startupImpl(access);
        }
    }

    public void shutDown() throws OXException {
        if (!this.startupFlag.compareAndSet(true, false)) {
            return;
        }
        MailAccess<?, ?> access = this.createNewMailAccess(null);
        if (null != access) {
            MailAccess.shutdownImpl(access);
        }
        this.getProtocolProps().resetProperties();
    }

    public MailPermission createNewMailPermission(Session session, int accountId) {
        return new DefaultMailPermission();
    }

    public SpamHandler getSpamHandler() {
        return SpamHandlerRegistry.getSpamHandler(this.getSpamHandlerName());
    }

    public abstract Protocol getProtocol();

    protected String getSpamHandlerName() {
        return "NoSpamHandler";
    }

    public final boolean supportsProtocol(String protocol) {
        return this.getProtocol().isSupported(protocol);
    }

    public abstract MailAccess<?, ?> createNewMailAccess(Session var1) throws OXException;

    public abstract MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> createNewMailAccess(Session var1, int var2) throws OXException;

    protected abstract AbstractProtocolProperties getProtocolProperties();

    public AbstractProtocolProperties getProtocolProps() {
        return this.getProtocolProperties();
    }
}

