/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api;

public abstract class MailCapabilities {
    public static final MailCapabilities EMPTY_CAPS = new MailCapabilities(){

        @Override
        public boolean hasPermissions() {
            return false;
        }

        @Override
        public boolean hasQuota() {
            return false;
        }

        @Override
        public boolean hasSort() {
            return false;
        }

        @Override
        public boolean hasSubscription() {
            return false;
        }

        @Override
        public boolean hasThreadReferences() {
            return false;
        }

        @Override
        public int getCapabilities() {
            return 0;
        }

        @Override
        public String toString() {
            return "Empty mail capabilities";
        }

        @Override
        public boolean hasFileNameSearch() {
            return false;
        }
    };
    public static final int BIT_PERMISSIONS;
    public static final int BIT_THREAD_REFERENCES;
    public static final int BIT_QUOTA;
    public static final int BIT_SORT;
    public static final int BIT_SUBSCRIPTION;
    protected static final int NEXT_SHIFT_OPERAND;

    protected MailCapabilities() {
    }

    public abstract boolean hasPermissions();

    public abstract boolean hasThreadReferences();

    public abstract boolean hasQuota();

    public abstract boolean hasSort();

    public abstract boolean hasSubscription();

    public boolean hasFileNameSearch() {
        return false;
    }

    public int getCapabilities() {
        int retval = 0;
        retval |= this.hasPermissions() ? BIT_PERMISSIONS : 0;
        retval |= this.hasQuota() ? BIT_QUOTA : 0;
        retval |= this.hasSort() ? BIT_SORT : 0;
        retval |= this.hasThreadReferences() ? BIT_THREAD_REFERENCES : 0;
        return retval |= this.hasSubscription() ? BIT_SUBSCRIPTION : 0;
    }

    public String toString() {
        return new StringBuilder(64).append(MailCapabilities.class.getSimpleName()).append(": hasPermissions=").append(this.hasPermissions()).append(", hasQuota=").append(this.hasQuota()).append(", hasSort=").append(this.hasSort()).append(", hasSubscription=").append(this.hasSubscription()).append(", hasThreadReferences=").append(this.hasThreadReferences()).toString();
    }

    static {
        int shiftOperand = 0;
        BIT_PERMISSIONS = 1 << shiftOperand++;
        BIT_THREAD_REFERENCES = 1 << shiftOperand++;
        BIT_QUOTA = 1 << shiftOperand++;
        BIT_SORT = 1 << shiftOperand++;
        BIT_SUBSCRIPTION = 1 << shiftOperand++;
        NEXT_SHIFT_OPERAND = shiftOperand;
    }
}

