/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.Protocol;
import com.openexchange.mail.api.AllMailProvider;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.utils.ProviderUtility;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.session.Session;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailProviderRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(MailProviderRegistry.class);
    private static final Protocol PROTOCOL_UNIFIED_MAIL = new Protocol(UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX);
    private static final ConcurrentMap<Protocol, MailProvider> PROVIDERS = new NonBlockingHashMap();
    private static final AtomicReference<AllMailProvider> ALL_PROVIDER = new AtomicReference();

    private MailProviderRegistry() {
    }

    public static boolean isUnifiedMailAvailable() {
        return PROVIDERS.containsKey(PROTOCOL_UNIFIED_MAIL);
    }

    public static List<Protocol> getProtocols() {
        return new ArrayList<Protocol>(PROVIDERS.keySet());
    }

    public static MailProvider getMailProviderBySession(Session session, int accountId) throws OXException {
        String protocol;
        MailProvider provider;
        MailSessionCache mailSessionCache = MailSessionCache.getInstance(session);
        String key = MailSessionParameterNames.getParamMailProvider();
        try {
            provider = (MailProvider)mailSessionCache.getParameter(accountId, key);
        }
        catch (ClassCastException e) {
            provider = null;
        }
        String mailServerURL = MailConfig.getMailServerURL(session, accountId).getServerURL();
        if (mailServerURL == null) {
            LOG.warn("Missing mail server URL. Mail server URL not set in account {} for user {} in context {}. Using fallback protocol {}", new Object[]{accountId, session.getUserId(), session.getContextId(), MailProperties.getInstance().getDefaultMailProvider()});
            protocol = MailProperties.getInstance().getDefaultMailProvider();
        } else {
            protocol = ProviderUtility.extractProtocol(mailServerURL, MailProperties.getInstance().getDefaultMailProvider());
        }
        if (null != provider && !provider.isDeprecated() && provider.supportsProtocol(protocol)) {
            return provider;
        }
        provider = MailProviderRegistry.getMailProvider(protocol);
        if (null == provider || !provider.supportsProtocol(protocol)) {
            throw MailExceptionCode.UNKNOWN_PROTOCOL.create(mailServerURL);
        }
        mailSessionCache.putParameter(accountId, key, provider);
        return provider;
    }

    public static MailProvider getMailProviderByURL(String serverUrl) {
        return MailProviderRegistry.getMailProvider(ProviderUtility.extractProtocol(serverUrl, MailProperties.getInstance().getDefaultMailProvider()));
    }

    public static MailProvider getMailProvider(String protocolName) {
        if (null == protocolName) {
            return null;
        }
        AllMailProvider all = ALL_PROVIDER.get();
        if (null != all) {
            MailProvider realMailProvider = MailProviderRegistry.getRealMailProvider(protocolName);
            return null == realMailProvider ? null : all.getDelegatingProvider(realMailProvider);
        }
        return MailProviderRegistry.getRealMailProvider(protocolName);
    }

    public static MailProvider getRealMailProvider(String protocolName) {
        if (null == protocolName) {
            return null;
        }
        for (Map.Entry entry : PROVIDERS.entrySet()) {
            if (!((Protocol)entry.getKey()).isSupported(protocolName)) continue;
            return (MailProvider)entry.getValue();
        }
        return null;
    }

    public static boolean registerMailProvider(String protocol, MailProvider provider) throws OXException {
        try {
            Protocol p = Protocol.parseProtocol(protocol);
            if (Protocol.PROTOCOL_ALL.equals(p)) {
                if (!ALL_PROVIDER.compareAndSet(null, (AllMailProvider)provider)) {
                    return false;
                }
                provider.startUp();
                provider.setDeprecated(false);
                return true;
            }
            if (null != PROVIDERS.putIfAbsent(p, provider)) {
                return false;
            }
            provider.startUp();
            provider.setDeprecated(false);
            return true;
        }
        catch (OXException e) {
            throw e;
        }
        catch (RuntimeException t) {
            LOG.error("", (Throwable)t);
            return false;
        }
    }

    public static void unregisterAll() {
        for (MailProvider provider : PROVIDERS.values()) {
            try {
                provider.setDeprecated(true);
                provider.shutDown();
            }
            catch (OXException e) {
                LOG.error("Mail connection implementation could not be shut down", (Throwable)e);
            }
            catch (RuntimeException t) {
                LOG.error("Mail connection implementation could not be shut down", (Throwable)t);
            }
        }
        PROVIDERS.clear();
        MailProvider all = ALL_PROVIDER.get();
        if (null != all) {
            try {
                all.setDeprecated(true);
                all.shutDown();
                ALL_PROVIDER.set(null);
            }
            catch (OXException e) {
                LOG.error("Mail connection implementation could not be shut down", (Throwable)e);
            }
            catch (RuntimeException t) {
                LOG.error("Mail connection implementation could not be shut down", (Throwable)t);
            }
        }
    }

    public static MailProvider unregisterMailProvider(MailProvider provider) throws OXException {
        Protocol protocol = provider.getProtocol();
        if (Protocol.PROTOCOL_ALL.equals(protocol)) {
            AllMailProvider all;
            while (!ALL_PROVIDER.compareAndSet(all = ALL_PROVIDER.get(), null)) {
            }
            if (null == all) {
                return null;
            }
            try {
                all.setDeprecated(true);
                all.shutDown();
            }
            catch (OXException e) {
                throw e;
            }
            catch (RuntimeException t) {
                LOG.error("", (Throwable)t);
            }
            return all;
        }
        MailProvider removed = (MailProvider)PROVIDERS.remove(protocol);
        if (null == removed) {
            return null;
        }
        try {
            removed.setDeprecated(true);
            removed.shutDown();
            return removed;
        }
        catch (OXException e) {
            throw e;
        }
        catch (RuntimeException t) {
            LOG.error("", (Throwable)t);
            return removed;
        }
    }

    public static MailProvider unregisterMailProviderByProtocol(String protocol) throws OXException {
        if ("*".equals(protocol)) {
            AllMailProvider all;
            while (!ALL_PROVIDER.compareAndSet(all = ALL_PROVIDER.get(), null)) {
            }
            if (null == all) {
                return null;
            }
            try {
                all.setDeprecated(true);
                all.shutDown();
            }
            catch (OXException e) {
                throw e;
            }
            catch (RuntimeException t) {
                LOG.error("", (Throwable)t);
            }
            return all;
        }
        Iterator iter = PROVIDERS.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!((Protocol)entry.getKey()).isSupported(protocol)) continue;
            iter.remove();
            ((MailProvider)entry.getValue()).setDeprecated(true);
            ((MailProvider)entry.getValue()).shutDown();
            return (MailProvider)entry.getValue();
        }
        return null;
    }
}

