/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.lock.impl;

import com.openexchange.concurrent.TimeoutConcurrentMap;
import com.openexchange.exception.OXException;
import com.openexchange.lock.LockService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockServiceImpl
implements LockService {
    private final TimeoutConcurrentMap<String, Lock> locks = new TimeoutConcurrentMap(30);

    public void dispose() {
        this.locks.dispose();
    }

    public Lock getLockFor(String identifier) throws OXException {
        return this.getLockFor0(identifier, false);
    }

    public Lock getSelfCleaningLockFor(String identifier) throws OXException {
        return this.getLockFor0(identifier, true);
    }

    private Lock getLockFor0(String identifier, boolean selfCleaning) {
        ReentrantLock newLock;
        Lock lock = this.locks.get(identifier);
        if (null == lock && null == (lock = this.locks.putIfAbsent(identifier, newLock = new ReentrantLock(), 150, null))) {
            lock = selfCleaning ? new SelfCleaningLock(newLock, identifier, this) : newLock;
        }
        return lock;
    }

    public void removeLockFor(String identifier) {
        this.locks.remove(identifier);
    }

    private static class SelfCleaningLock
    implements Lock {
        private final Lock lock;
        private final LockServiceImpl lockServiceImpl;
        private final String identifier;

        SelfCleaningLock(Lock lock, String identifier, LockServiceImpl lockServiceImpl) {
            this.lock = lock;
            this.identifier = identifier;
            this.lockServiceImpl = lockServiceImpl;
        }

        @Override
        public void lock() {
            this.lock.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lock.lockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return this.lock.tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.lock.tryLock(time, unit);
        }

        @Override
        public void unlock() {
            this.lockServiceImpl.removeLockFor(this.identifier);
            this.lock.unlock();
        }

        @Override
        public Condition newCondition() {
            return this.lock.newCondition();
        }
    }
}

