/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.upload.impl;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.IteratorOnlyServletFileUpload;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.groupware.upload.impl.UploadFileImpl;
import com.openexchange.groupware.upload.impl.UploadFileSizeExceededException;
import com.openexchange.groupware.upload.impl.UploadSizeExceededException;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.servlet.http.Tools;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.james.mime4j.field.contenttype.parser.ContentTypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UploadUtility {
    private static final Logger LOG = LoggerFactory.getLogger(UploadUtility.class);
    private static final TIntObjectMap<String> M = new TIntObjectHashMap(13);
    private static final AtomicReference<ScheduledTimerTask> TIMER_TASK_REFERENCE;
    private static final int SIZE_THRESHOLD = 0x100000;
    private static final String PREFIX;

    private UploadUtility() {
    }

    public static void shutDown() {
        ScheduledTimerTask timerTask;
        do {
            if (null != (timerTask = TIMER_TASK_REFERENCE.get())) continue;
            return;
        } while (!TIMER_TASK_REFERENCE.compareAndSet(timerTask, null));
        timerTask.cancel(true);
    }

    public static String getSize(long size) {
        return UploadUtility.getSize(size, 2, false, true);
    }

    public static String getSize(long size, int precision, boolean longName, boolean realSize) {
        int base;
        int pos = 0;
        double decSize = size;
        int n = base = realSize ? 1024 : 1000;
        while (decSize > (double)base) {
            decSize /= (double)base;
            ++pos;
        }
        int num = (int)Math.pow(10.0, precision);
        StringBuilder sb = new StringBuilder(8).append((double)Math.round(decSize * (double)num) / (double)num).append(' ');
        if (longName) {
            sb.append(UploadUtility.getSizePrefix(pos)).append("bytes");
        } else {
            String prefix = UploadUtility.getSizePrefix(pos);
            if (0 == prefix.length()) {
                sb.append("bytes");
            } else {
                sb.append(String.valueOf(prefix.charAt(0))).append('B');
            }
        }
        return sb.toString();
    }

    private static String getSizePrefix(int pos) {
        String prefix = (String)M.get(pos);
        if (prefix != null) {
            return prefix;
        }
        return "?-";
    }

    public static ServletFileUpload newThresholdFileUploadBase(long maxFileSize, long maxOverallSize) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(0x100000);
        factory.setRepository(new File(ServerConfig.getProperty(ServerConfig.Property.UploadDirectory)));
        ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)factory);
        sfu.setFileSizeMax(maxFileSize);
        sfu.setSizeMax(maxOverallSize);
        return sfu;
    }

    public static ServletFileUpload newFileUploadBase(long maxFileSize, long maxOverallSize) {
        ServletFileUpload sfu = new ServletFileUpload();
        sfu.setFileSizeMax(maxFileSize);
        sfu.setSizeMax(maxOverallSize);
        return new IteratorOnlyServletFileUpload(sfu);
    }

    public static UploadEvent processUpload(HttpServletRequest req, long maxFileSize, long maxOverallSize) throws OXException {
        FileItemIterator iter;
        String action;
        if (!Tools.isMultipartContent(req)) {
            throw UploadException.UploadCode.NO_MULTIPART_CONTENT.create();
        }
        try {
            action = AJAXServlet.getAction(req);
        }
        catch (OXException e) {
            throw UploadException.UploadCode.UPLOAD_FAILED.create(e, new Object[0]);
        }
        try {
            ServletFileUpload upload = UploadUtility.newFileUploadBase(maxFileSize, maxOverallSize > 0L ? maxOverallSize + 1024L : maxOverallSize);
            if (null == req.getCharacterEncoding()) {
                String defaultEnc = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
                try {
                    req.setCharacterEncoding(defaultEnc);
                }
                catch (Exception e) {
                    // empty catch block
                }
                upload.setHeaderEncoding(defaultEnc);
            }
            iter = upload.getItemIterator(req);
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            throw UploadFileSizeExceededException.create(e.getActualSize(), e.getPermittedSize(), true);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            throw UploadSizeExceededException.create(e.getActualSize(), e.getPermittedSize(), true);
        }
        catch (FileUploadException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                String message = cause.getMessage();
                if (null != message && message.startsWith("Max. byte count of ")) {
                    int pos = message.indexOf(" exceeded", 20);
                    String limit = message.substring(19, pos);
                    throw UploadException.UploadCode.MAX_UPLOAD_SIZE_EXCEEDED_UNKNOWN.create(cause, UploadUtility.getSize(Long.parseLong(limit), 2, false, true));
                }
            } else if (cause instanceof EOFException) {
                throw UploadException.UploadCode.UNEXPECTED_EOF.create(cause, cause.getMessage());
            }
            throw UploadException.UploadCode.UPLOAD_FAILED.create(e, null == cause ? e.getMessage() : (null == cause.getMessage() ? e.getMessage() : cause.getMessage()));
        }
        catch (IOException e) {
            throw UploadException.UploadCode.UPLOAD_FAILED.create(e, action);
        }
        UploadEvent uploadEvent = new UploadEvent();
        uploadEvent.setAction(action);
        uploadEvent.setAffiliationId(1);
        boolean error = true;
        try {
            String rce = req.getCharacterEncoding();
            String charEnc = null == rce ? ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding) : rce;
            String uploadDir = ServerConfig.getProperty(ServerConfig.Property.UploadDirectory);
            String fileName = req.getParameter("filename");
            long current = 0L;
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                if (item.isFormField()) {
                    uploadEvent.addFormField(item.getFieldName(), Streams.stream2string((InputStream)item.openStream(), (String)charEnc));
                    continue;
                }
                String name = item.getName();
                if (Strings.isEmpty((String)name)) continue;
                UploadFile uf = UploadUtility.processUploadedFile(item, uploadDir, Strings.isEmpty((String)fileName) ? name : fileName, current, maxFileSize, maxOverallSize);
                current += uf.getSize();
                uploadEvent.addUploadFile(uf);
            }
            if (maxOverallSize > 0L && current > maxOverallSize) {
                throw UploadSizeExceededException.create(current, maxOverallSize, true);
            }
            if (uploadEvent.getAffiliationId() < 0) {
                throw UploadException.UploadCode.MISSING_AFFILIATION_ID.create(action);
            }
            error = false;
            UploadEvent uploadEvent2 = uploadEvent;
            return uploadEvent2;
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            throw UploadFileSizeExceededException.create(e.getActualSize(), e.getPermittedSize(), true);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            throw UploadSizeExceededException.create(e.getActualSize(), e.getPermittedSize(), true);
        }
        catch (FileUploadException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                String message = cause.getMessage();
                if (null != message && message.startsWith("Max. byte count of ")) {
                    int pos = message.indexOf(" exceeded", 20);
                    String limit = message.substring(19, pos);
                    throw UploadException.UploadCode.MAX_UPLOAD_SIZE_EXCEEDED_UNKNOWN.create(cause, UploadUtility.getSize(Long.parseLong(limit), 2, false, true));
                }
            } else if (cause instanceof EOFException) {
                throw UploadException.UploadCode.UNEXPECTED_EOF.create(cause, cause.getMessage());
            }
            throw UploadException.UploadCode.UPLOAD_FAILED.create(e, null == cause ? e.getMessage() : (null == cause.getMessage() ? e.getMessage() : cause.getMessage()));
        }
        catch (FileUploadBase.FileUploadIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FileUploadBase.FileSizeLimitExceededException) {
                FileUploadBase.FileSizeLimitExceededException exc = (FileUploadBase.FileSizeLimitExceededException)cause;
                throw UploadFileSizeExceededException.create(exc.getActualSize(), exc.getPermittedSize(), true);
            }
            if (cause instanceof FileUploadBase.SizeLimitExceededException) {
                FileUploadBase.SizeLimitExceededException exc = (FileUploadBase.SizeLimitExceededException)cause;
                throw UploadSizeExceededException.create(exc.getActualSize(), exc.getPermittedSize(), true);
            }
            throw UploadException.UploadCode.UPLOAD_FAILED.create(e, action);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TimeoutException) {
                throw UploadException.UploadCode.UNEXPECTED_TIMEOUT.create(e, new Object[0]);
            }
            throw UploadException.UploadCode.UPLOAD_FAILED.create(e, action);
        }
        catch (RuntimeException e) {
            throw UploadException.UploadCode.UPLOAD_FAILED.create(e, action);
        }
        finally {
            if (error) {
                uploadEvent.cleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static UploadFile processUploadedFile(FileItemStream item, String uploadDir, String fileName, long current, long maxFileSize, long maxOverallSize) throws IOException, FileUploadException {
        retval = new UploadFileImpl();
        retval.setFieldName(item.getFieldName());
        retval.setFileName(fileName);
        mimeType = MimeType2ExtMap.getContentType(fileName, null);
        forcedMimeType = item.getHeaders().getHeader("X-Forced-MIME-Type");
        if (null == forcedMimeType) {
            retval.setContentType(null == mimeType ? item.getContentType() : mimeType);
        } else if (AJAXRequestDataTools.parseBoolParameter(forcedMimeType)) {
            retval.setContentType(item.getContentType());
        } else {
            try {
                parser = new ContentTypeParser((Reader)new StringReader(forcedMimeType));
                parser.parseAll();
                retval.setContentType(parser.getType() + '/' + parser.getSubType());
            }
            catch (Exception e) {
                retval.setContentType(null == mimeType ? item.getContentType() : mimeType);
            }
        }
        size = 0L;
        if (maxOverallSize > 0L && current > maxOverallSize) {
            size = Streams.countInputStream((InputStream)item.openStream());
            retval.setSize(size);
            return retval;
        }
        tmpFile = File.createTempFile(UploadUtility.PREFIX, null, new File(uploadDir));
        tmpFile.deleteOnExit();
        UploadUtility.startUploadEvicterIfNotYetDone();
        in = null;
        out = null;
        error = true;
        try {
            block15: {
                in = Streams.getNonEmpty((InputStream)item.openStream());
                if (null != in) break block15;
                UploadUtility.LOG.warn("Detected empty upload file {}.", (Object)retval.getFileName());
                ** GOTO lbl65
            }
            out = new FileOutputStream(tmpFile, false);
            buflen = 65536;
            buf = new byte[buflen];
            while ((read = in.read(buf, 0, buflen)) > 0) {
                out.write(buf, 0, read);
                if (maxFileSize > 0L && (size += (long)read) > maxFileSize) {
                    Streams.close((Closeable)out);
                    tmpFile.delete();
                    throw new FileUploadBase.FileSizeLimitExceededException("File size exceeded", size += Streams.countInputStream((InputStream)in), maxFileSize);
                }
                if (maxOverallSize <= 0L || current + size <= maxOverallSize) continue;
                Streams.close((Closeable)out);
                tmpFile.delete();
                retval.setSize(size += Streams.countInputStream((InputStream)in));
                var20_19 = retval;
            }
        }
        catch (Throwable var21_20) {
            Streams.close((Closeable[])new Closeable[]{in, out});
            if (error) {
                tmpFile.delete();
            }
            throw var21_20;
        }
        {
            Streams.close((Closeable[])new Closeable[]{in, out});
            if (error) {
                tmpFile.delete();
            }
            return var20_19;
        }
        out.flush();
lbl65:
        // 2 sources

        error = false;
        Streams.close((Closeable[])new Closeable[]{in, out});
        if (error) {
            tmpFile.delete();
        }
        retval.setSize(size);
        retval.setTmpFile(tmpFile);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void startUploadEvicterIfNotYetDone() {
        ScheduledTimerTask timerTask = TIMER_TASK_REFERENCE.get();
        if (null != timerTask) return;
        Class<UploadUtility> clazz = UploadUtility.class;
        synchronized (UploadUtility.class) {
            timerTask = TIMER_TASK_REFERENCE.get();
            if (null != timerTask) return;
            try {
                UploadEvicter evicter = new UploadEvicter(PREFIX, LOG);
                TimerService timerService = ServerServiceRegistry.getInstance().getService(TimerService.class);
                long delay = 300000L;
                timerTask = timerService.scheduleWithFixedDelay((Runnable)evicter, 3000L, delay);
                TIMER_TASK_REFERENCE.set(timerTask);
            }
            catch (Exception e) {
                LOG.warn("Failed to initialze {}", (Object)UploadEvicter.class.getSimpleName(), (Object)e);
            }
            return;
        }
    }

    static {
        int pos = 0;
        M.put(pos++, (Object)"");
        M.put(pos++, (Object)"Kilo");
        M.put(pos++, (Object)"Mega");
        M.put(pos++, (Object)"Giga");
        M.put(pos++, (Object)"Tera");
        M.put(pos++, (Object)"Peta");
        M.put(pos++, (Object)"Exa");
        M.put(pos++, (Object)"Zetta");
        M.put(pos++, (Object)"Yotta");
        M.put(pos++, (Object)"Xenna");
        M.put(pos++, (Object)"W-");
        M.put(pos++, (Object)"Vendeka");
        M.put(pos++, (Object)"U-");
        TIMER_TASK_REFERENCE = new AtomicReference();
        PREFIX = "openexchange-upload-" + OXException.getServerId() + "-";
    }

    private static final class UploadEvicter
    implements Runnable {
        private final Logger logger;
        private final String prefix;
        private final Object mutex;
        private final LinkedHashSet<String> files;
        private int filesLastSize = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        UploadEvicter(String prefix, Logger logger) {
            this.logger = logger;
            this.prefix = prefix;
            try {
                Class<?> clazz = Class.forName("java.io.DeleteOnExitHook");
                Field[] declaredFields = clazz.getDeclaredFields();
                Field filesField = this.getFieldFrom("files", declaredFields);
                filesField.setAccessible(true);
                LinkedHashSet files = (LinkedHashSet)filesField.get(null);
                if (null == files) {
                    throw new IllegalStateException("Can't initialize. Are you running Java 6+ or within a restricted SecurityManager?");
                }
                this.files = files;
                this.mutex = this.isJavaVersionGreaterThan160_20() ? clazz : files;
                Object object = this.mutex;
                synchronized (object) {
                    this.filesLastSize = files.size();
                }
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this.mutex;
                synchronized (object) {
                    int total;
                    this.logger.debug("DeleteOnExitHook went from {} to {} file entries.", (Object)this.filesLastSize, (Object)this.files.size());
                    int existent = 0;
                    int removed = 0;
                    Iterator iterator = this.files.iterator();
                    for (total = removed + existent; iterator.hasNext() && total < this.filesLastSize; ++total) {
                        String fileName = (String)iterator.next();
                        if (fileName == null || !new File(fileName).exists()) {
                            this.logger.trace("Removing file entry {}", (Object)fileName);
                            iterator.remove();
                            ++removed;
                            continue;
                        }
                        ++existent;
                    }
                    if (removed > 0) {
                        this.logger.debug("removed {}/{} entries", (Object)removed, (Object)total);
                    }
                    this.filesLastSize = this.files.size();
                    if (this.filesLastSize > 0) {
                        long stamp = System.currentTimeMillis() - 1800000L;
                        ArrayList<String> toBeDeleted = new ArrayList<String>(this.files);
                        Collections.reverse(toBeDeleted);
                        for (String filename : toBeDeleted) {
                            File file = new File(filename);
                            if (!file.getName().startsWith(this.prefix) || file.lastModified() >= stamp) continue;
                            this.logger.debug("Found expired file entry {}. Deleting...", (Object)filename);
                            if (file.delete() || !file.exists()) continue;
                            this.logger.warn("Temporary file could not be deleted: {}", (Object)file.getPath());
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private Field getFieldFrom(String name, Field[] declaredFields) {
            for (Field field : declaredFields) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
            return null;
        }

        private boolean isJavaVersionGreaterThan160_20() {
            try {
                float javaClassVersion = Float.parseFloat(this.getSystemProperty("java.class.version"));
                if (javaClassVersion <= 49.0f) {
                    return false;
                }
                if (javaClassVersion > 50.0f) {
                    return true;
                }
                String javaVersion = this.getJavaVersionTrimmed();
                assert (javaVersion.startsWith("1.6")) : javaVersion;
                String patchLevelStr = javaVersion.substring(javaVersion.indexOf(95) + 1);
                return Integer.parseInt(patchLevelStr) > 20;
            }
            catch (RuntimeException e) {
                return true;
            }
        }

        private String getJavaVersionTrimmed() {
            String javaVersion = this.getSystemProperty("java.version");
            if (javaVersion != null) {
                for (int i = 0; i < javaVersion.length(); ++i) {
                    char ch = javaVersion.charAt(i);
                    if (ch < '0' || ch > '9') continue;
                    return javaVersion.substring(i);
                }
            }
            return null;
        }

        private String getSystemProperty(String property) {
            try {
                return System.getProperty(property);
            }
            catch (SecurityException ex) {
                this.logger.warn("Encountered a SecurityException reading the system property '{}'; returning null instead.", (Object)property, (Object)ex);
                return null;
            }
        }
    }
}

