/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ResourceClearDelTablesTask
extends UpdateTaskAdapter {
    private static final String[] OBSOLETE_COLUMNS = new String[]{"identifier", "displayName", "mail", "available", "description"};
    private static final String TABLE = "del_resource";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = dbService.getForUpdateTask(ctxId);
        PreparedStatement stmt = null;
        try {
            con.setAutoCommit(false);
            block17: for (String column : OBSOLETE_COLUMNS) {
                int type = Tools.getColumnType(con, TABLE, column);
                if (!Tools.hasDefaultValue(con, TABLE, column)) {
                    stmt = con.prepareStatement("ALTER TABLE del_resource ALTER " + column + " SET DEFAULT ?");
                    switch (type) {
                        case 1: 
                        case 12: {
                            stmt.setString(1, "");
                            break;
                        }
                        case 91: 
                        case 93: {
                            stmt.setDate(1, new Date(0L));
                            break;
                        }
                        case -6: 
                        case 16: {
                            stmt.setInt(1, 0);
                            break;
                        }
                        case -1: 
                        case 2004: {
                            stmt.cancel();
                            stmt.close();
                            continue block17;
                        }
                        default: {
                            stmt.setInt(1, -1);
                        }
                    }
                    stmt.executeUpdate();
                    stmt.close();
                }
                if (Tools.isNullable(con, TABLE, column)) {
                    stmt = con.prepareStatement("UPDATE del_resource SET " + column + " = NULL");
                    stmt.executeUpdate();
                    stmt.close();
                    continue;
                }
                stmt = con.prepareStatement("UPDATE del_resource SET " + column + " = ?");
                switch (type) {
                    case 1: 
                    case 12: {
                        stmt.setString(1, "");
                        break;
                    }
                    case 91: 
                    case 93: {
                        stmt.setDate(1, new Date(0L));
                        break;
                    }
                    case -6: 
                    case 16: {
                        stmt.setInt(1, 0);
                        break;
                    }
                    default: {
                        stmt.setInt(1, -1);
                    }
                }
                stmt.executeUpdate();
                stmt.close();
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            DBUtils.closeSQLStuff(stmt);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

