/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.PrgContactsLinkageAddUuidUpdateTask;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

public class PrgContactsLinkageAddPrimaryKeyUpdateTask
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        Column column = new Column("uuid", "BINARY(16) NOT NULL");
        try {
            con.setAutoCommit(false);
            Tools.modifyColumns(con, "prg_contacts_linkage", column);
            Tools.createPrimaryKeyIfAbsent(con, "prg_contacts_linkage", new String[]{"cid", column.name});
            this.setUUID(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{PrgContactsLinkageAddUuidUpdateTask.class.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setUUID(Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT intfield01, intfield02, field01, field02, cid FROM prg_contacts_linkage WHERE uuid IS NULL FOR UPDATE");
            rs = stmt.executeQuery();
            while (rs.next()) {
                PreparedStatement stmt2 = null;
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append("UPDATE prg_contacts_linkage SET uuid = ? WHERE intfield01 ");
                    int oldPos = 1;
                    int intfield01 = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND intfield02 ");
                    int intfield02 = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND field01 ");
                    String field01 = rs.getString(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND field02 ");
                    String field02 = rs.getString(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND cid ");
                    int cid = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    stmt2 = con.prepareStatement(sb.toString());
                    int newPos = 1;
                    UUID uuid = UUID.randomUUID();
                    stmt2.setBytes(newPos++, UUIDs.toByteArray((UUID)uuid));
                    stmt2.setInt(newPos++, intfield01);
                    stmt2.setInt(newPos++, intfield02);
                    stmt2.setString(newPos++, field01);
                    stmt2.setString(newPos++, field02);
                    stmt2.setInt(newPos++, cid);
                    stmt2.execute();
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt2);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(stmt2);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }
}

