/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class MailAccountAddReplyToTask
extends UpdateTaskAdapter {
    private static final String[] DEPENDENCIES = new String[0];

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING);
    }

    @Override
    public String[] getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        PreparedStatement stmt = null;
        try {
            if (!Tools.columnExists(con, "user_mail_account", "replyTo")) {
                stmt = con.prepareStatement("ALTER TABLE user_mail_account ADD COLUMN replyTo VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL");
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
            }
            if (!Tools.columnExists(con, "user_transport_account", "replyTo")) {
                stmt = con.prepareStatement("ALTER TABLE user_transport_account ADD COLUMN replyTo VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL");
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
            }
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                Database.backNoTimeout(contextId, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        Database.backNoTimeout(contextId, true, con);
    }
}

