/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.AbstractCreateTableImpl;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class HeaderCacheCreateTableTask
extends AbstractCreateTableImpl
implements UpdateTaskV2 {
    private static String getCreateMailUUIDTable() {
        return "CREATE TABLE mailUUID ( cid INT4 unsigned NOT NULL, user INT4 unsigned NOT NULL, account INT4 unsigned NOT NULL, fullname VARCHAR(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, id VARCHAR(70) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, uuid BINARY(16) NOT NULL, PRIMARY KEY (cid, user, account, fullname, id), INDEX (cid, user, uuid)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    private static final String getCreateHeaderBlobTable() {
        return "CREATE TABLE headersAsBlob ( cid INT4 unsigned NOT NULL, user INT4 unsigned NOT NULL, uuid BINARY(16) NOT NULL, flags INT4 unsigned NOT NULL default '0', receivedDate bigint(64) default NULL, rfc822Size bigint(64) UNSIGNED NOT NULL, userFlags VARCHAR(1024) collate utf8_unicode_ci default NULL, headers BLOB, PRIMARY KEY (cid, user, uuid)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    public String[] getCreateStatements() {
        return new String[]{HeaderCacheCreateTableTask.getCreateMailUUIDTable(), HeaderCacheCreateTableTask.getCreateHeaderBlobTable()};
    }

    public String[] requiredTables() {
        return new String[]{"user"};
    }

    public String[] tablesToCreate() {
        return new String[]{"mailUUID", "headersAsBlob"};
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes();
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        this.createTable("mailUUID", HeaderCacheCreateTableTask.getCreateMailUUIDTable(), contextId);
        this.createTable("headersAsBlob", HeaderCacheCreateTableTask.getCreateHeaderBlobTable(), contextId);
    }

    private void createTable(String tablename, String sqlCreate, int contextId) throws OXException {
        Connection writeCon = Database.get(contextId, true);
        PreparedStatement stmt = null;
        try {
            if (Tools.tableExists(writeCon, tablename)) {
                return;
            }
            stmt = writeCon.prepareStatement(sqlCreate);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            Database.back(contextId, true, writeCon);
        }
        Database.back(contextId, true, writeCon);
    }
}

