/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.groupware.update.tasks.RemoveFacebookAccountsTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class DropVersionTableTask
extends UpdateTaskAdapter {
    private final String TABLE = "version";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = null;
        DatabaseService ds = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        try {
            con = ds.getForUpdateTask(contextId);
            if (Tools.tableExists(con, "version")) {
                Tools.dropTable(con, "version");
            }
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (null != con) {
                ds.backForUpdateTask(contextId, con);
            }
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{RemoveFacebookAccountsTask.class.getName()};
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND, WorkingLevel.SCHEMA);
    }
}

