/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.tools.sql.DBUtils;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarExtendDNColumnTaskV2
implements UpdateTaskV2 {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarExtendDNColumnTaskV2.class);
    private static final int DESIRED_SIZE = 320;
    private static final String SQL_MODIFY = "ALTER TABLE #TABLE# MODIFY dn varchar(320) collate utf8_unicode_ci default NULL";

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes();
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        LOG.info("Starting {}", (Object)CalendarExtendDNColumnTaskV2.class.getSimpleName());
        this.modifyColumnInTable("prg_date_rights", contextId);
        this.modifyColumnInTable("del_date_rights", contextId);
        LOG.info("{} finished.", (Object)CalendarExtendDNColumnTaskV2.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void modifyColumnInTable(String tableName, int contextId) throws OXException {
        block14: {
            CalendarExtendDNColumnTaskV2.LOG.info("{}: Going to extend size of column `dn` in table `{}`.", (Object)CalendarExtendDNColumnTaskV2.class.getSimpleName(), (Object)tableName);
            con = Database.getNoTimeout(contextId, true);
            rs = null;
            try {
                metadata = con.getMetaData();
                rs = metadata.getColumns(null, null, tableName, null);
                columnName = "dn";
lbl9:
                // 2 sources

                while (rs.next()) {
                    name = rs.getString("COLUMN_NAME");
                    if (!"dn".equals(name) || (size = rs.getInt("COLUMN_SIZE")) < 320) break block14;
                    CalendarExtendDNColumnTaskV2.LOG.info("{}: Column {}.{} with size {} is already equal to/greater than {}", new Object[]{CalendarExtendDNColumnTaskV2.class.getSimpleName(), tableName, name, size, 320});
                    break;
                }
            }
            finally {
                Database.backNoTimeout(contextId, true, con);
            }
            DBUtils.closeSQLStuff(rs);
            rs = null;
            return;
        }
        ** GOTO lbl9
        DBUtils.closeSQLStuff(rs);
        rs = null;
        stmt = null;
        try {
            stmt = con.prepareStatement("ALTER TABLE #TABLE# MODIFY dn varchar(320) collate utf8_unicode_ci default NULL".replaceFirst("#TABLE#", tableName));
            stmt.executeUpdate();
            ** GOTO lbl46
        }
        catch (SQLException e) {
            try {
                throw CalendarExtendDNColumnTaskV2.wrapSQLException(e);
            }
            catch (Throwable var10_12) {
                DBUtils.closeSQLStuff(stmt);
                throw var10_12;
                catch (SQLException e) {
                    try {
                        throw CalendarExtendDNColumnTaskV2.wrapSQLException(e);
                    }
                    catch (Throwable var9_11) {
                        DBUtils.closeSQLStuff(rs);
                        rs = null;
                        throw var9_11;
                    }
                }
lbl46:
                // 1 sources

                DBUtils.closeSQLStuff(stmt);
            }
        }
        CalendarExtendDNColumnTaskV2.LOG.info("{}: Size of column `dn` in table `{}` successfully extended.", (Object)CalendarExtendDNColumnTaskV2.class.getSimpleName(), (Object)tableName);
    }

    private static OXException wrapSQLException(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

