/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentCountUpdateTask
extends UpdateTaskAdapter {
    static final Logger LOG = LoggerFactory.getLogger(AttachmentCountUpdateTask.class);
    private static final String SELECT = "SELECT pd.cid, pd.intfield01 AS id, pd.intfield08 AS count, COUNT(pa.id) AS realCount FROM prg_dates pd LEFT JOIN prg_attachment pa ON pd.cid = pa.cid AND pd.intfield01 = pa.attached AND pa.module=1 GROUP BY pd.cid,pd.intfield01 HAVING count!=realCount";
    private static final String REPAIR = "UPDATE prg_dates SET intfield08 = ? WHERE cid = ? AND intfield01 = ?";

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class, true);
        Connection con = dbService.getForUpdateTask(contextId);
        PreparedStatement repairStmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con.setAutoCommit(false);
            stmt = con.createStatement();
            rs = stmt.executeQuery(SELECT);
            repairStmt = con.prepareStatement(REPAIR);
            while (rs.next()) {
                int cid = rs.getInt("cid");
                int id = rs.getInt("id");
                int count = rs.getInt("count");
                int realCount = rs.getInt("realCount");
                repairStmt.setInt(1, realCount);
                repairStmt.setInt(2, cid);
                repairStmt.setInt(3, id);
                repairStmt.addBatch();
                LOG.info("Fixed appointment {}/{} (cid/id) old count: {} new count: {}", new Object[]{cid, id, count, realCount});
            }
            repairStmt.executeBatch();
            con.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.autocommit(con);
                DBUtils.closeSQLStuff(repairStmt);
                DBUtils.closeSQLStuff(rs, stmt);
                dbService.backForUpdateTask(contextId, con);
                throw throwable;
            }
        }
        DBUtils.autocommit(con);
        DBUtils.closeSQLStuff(repairStmt);
        DBUtils.closeSQLStuff(rs, stmt);
        dbService.backForUpdateTask(contextId, con);
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND, WorkingLevel.SCHEMA);
    }
}

