/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.notify.EmailableParticipant;
import com.openexchange.groupware.notify.ParticipantNotify;
import com.openexchange.groupware.notify.PooledNotification;
import com.openexchange.groupware.notify.State;
import com.openexchange.i18n.tools.RenderMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotificationPool {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationPool.class);
    private static final NotificationPool INSTANCE = new NotificationPool();
    private final AtomicBoolean started = new AtomicBoolean();
    private final ReadWriteLock lock;
    private final Lock readLock;
    private volatile ScheduledTimerTask timerTask;
    private final Map<PooledNotification, PooledNotification> map = new ConcurrentHashMap<PooledNotification, PooledNotification>(1024, 0.9f, 1);
    private final DelayQueue<PooledNotification> queue = new DelayQueue();

    public static NotificationPool getInstance() {
        return INSTANCE;
    }

    private NotificationPool() {
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByObject(int objectId, int contextId) {
        this.readLock.lock();
        try {
            Iterator<PooledNotification> queueIter = this.queue.iterator();
            while (queueIter.hasNext()) {
                PooledNotification pn = queueIter.next();
                if (!pn.equalsByObject(objectId, contextId)) continue;
                this.map.remove(pn);
                queueIter.remove();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(PooledNotification pooledNotification) {
        this.readLock.lock();
        try {
            PooledNotification prev = this.map.get(pooledNotification);
            if (prev == null) {
                this.map.put(pooledNotification, pooledNotification);
                this.queue.offer(pooledNotification);
                LOG.debug("New pooled notification added for receiver {}", (Object)pooledNotification.getParticipant().email);
            } else {
                prev.merge(pooledNotification);
                prev.touch();
                LOG.debug("Pooled notification merged for receiver {}", (Object)pooledNotification.getParticipant().email);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<PooledNotification> getNotifications() {
        return new ArrayList<PooledNotification>(this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.readLock.lock();
        try {
            this.queue.clear();
            this.map.clear();
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void sendAllMessages() {
        new NotificationPoolTimerTask(this.map, this.queue, this.lock.writeLock()).run();
    }

    public void startup() {
        TimerService timer;
        if (this.started.compareAndSet(false, true) && null != (timer = ServerServiceRegistry.getInstance().getService(TimerService.class))) {
            this.timerTask = timer.scheduleWithFixedDelay((Runnable)new NotificationPoolTimerTask(this.map, this.queue, this.lock.writeLock()), 1000L, 60000L);
        }
    }

    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            ScheduledTimerTask timerTask = this.timerTask;
            timerTask.cancel(false);
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null != timer) {
                timer.purge();
            }
            this.map.clear();
            this.queue.clear();
            this.timerTask = null;
        }
    }

    private class NotificationPoolTimerTask
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(NotificationPoolTimerTask.class);
        private final Lock taskWriteLock;
        private final Map<PooledNotification, PooledNotification> taskMap;
        private final DelayQueue<PooledNotification> taskQueue;

        public NotificationPoolTimerTask(Map<PooledNotification, PooledNotification> map, DelayQueue<PooledNotification> queue, Lock writeLock) {
            this.taskMap = map;
            this.taskQueue = queue;
            this.taskWriteLock = writeLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.taskWriteLock.lock();
            try {
                PooledNotification cur = (PooledNotification)this.taskQueue.poll();
                if (null != cur) {
                    StringBuilder b = new StringBuilder(2048);
                    do {
                        this.taskMap.remove(cur);
                        this.handlePooledNotification(cur, b);
                    } while (null != (cur = (PooledNotification)this.taskQueue.poll()));
                }
            }
            catch (Throwable t) {
                this.logger.error("", t);
            }
            finally {
                this.taskWriteLock.unlock();
            }
        }

        private void handlePooledNotification(PooledNotification cur, StringBuilder b) {
            EmailableParticipant p = cur.getParticipant();
            this.logger.debug("Found elapsed pooled notification for receiver {}", (Object)p.email);
            RenderMap renderMap = cur.getRenderMap();
            renderMap.applyLocale(cur.getLocale());
            renderMap.applyTimeZone(p.timeZone == null ? TimeZone.getDefault() : p.timeZone);
            State state = cur.getState();
            CalendarObject calendarObject = cur.getCalendarObject();
            if (ParticipantNotify.checkStartAndEndDate(calendarObject, state.getModule())) {
                ParticipantNotify.MailMessage mmsg = 1 == p.type ? ParticipantNotify.createUserMessage(cur.getSession(), calendarObject, p, ParticipantNotify.userCanReadObject(p, calendarObject, cur.getSession()), cur.getTitle(), cur.getState().getAction(), state, cur.getLocale(), cur.getRenderMap(), true, b) : ParticipantNotify.createParticipantMessage(cur.getSession(), calendarObject, p, cur.getTitle(), cur.getState().getAction(), state, cur.getLocale(), cur.getRenderMap(), true, b);
                this.logger.debug("Pooled {} (id = {}) notification message generated for receiver {}", new Object[]{1 == state.getModule() ? "Appointment" : "Task", calendarObject.getObjectID(), p.email});
                if (null != mmsg) {
                    ParticipantNotify.sendMessage(mmsg, cur.getSession(), calendarObject, state);
                }
            }
        }
    }
}

