/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.infostore.webdav.EntityLockHelper;
import com.openexchange.groupware.infostore.webdav.InfostoreWebdavFactory;
import com.openexchange.groupware.infostore.webdav.OXWebdavResource;
import com.openexchange.groupware.infostore.webdav.URLCache;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavMethod;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.helpers.AbstractCollection;
import com.openexchange.webdav.protocol.helpers.AbstractResource;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfostoreLockNullResource
extends AbstractCollection
implements OXWebdavResource {
    private static final WebdavMethod[] OPTIONS = new WebdavMethod[]{WebdavMethod.PUT, WebdavMethod.MKCOL, WebdavMethod.OPTIONS, WebdavMethod.PROPFIND, WebdavMethod.LOCK, WebdavMethod.UNLOCK, WebdavMethod.TRACE};
    private static final Logger LOG = LoggerFactory.getLogger(InfostoreLockNullResource.class);
    private final InfostoreWebdavFactory factory;
    private AbstractResource resource;
    private final SessionHolder sessionHolder;
    private final EntityLockHelper lockHelper;
    private final DBProvider provider;
    private boolean exists;
    private int id;

    public InfostoreLockNullResource(AbstractResource resource, InfostoreWebdavFactory factory) {
        this.resource = resource;
        this.factory = factory;
        this.sessionHolder = factory.getSessionHolder();
        this.lockHelper = new EntityLockHelper(factory.getLockNullLockManager(), this.sessionHolder, resource.getUrl());
        this.provider = factory.getProvider();
    }

    public InfostoreLockNullResource(AbstractResource resource, InfostoreWebdavFactory factory, int id) {
        this(resource, factory);
        this.setId(id);
    }

    public static int findInfostoreLockNullResource(WebdavPath url, Connection readCon, Context ctx) throws WebdavProtocolException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.prepareStatement("SELECT id FROM lock_null WHERE url = ? and cid = ?");
            stmt.setString(1, url.toEscapedString());
            stmt.setInt(2, ctx.getContextId());
            rs = stmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException x) {
            throw WebdavProtocolException.generalError(url, 500);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e1) {
                    LOG.debug("", (Throwable)e1);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.debug("", (Throwable)e);
                }
            }
        }
    }

    private void setId(int id2) {
        this.id = id2;
        this.lockHelper.setId(id2);
        this.exists = true;
    }

    @Override
    protected WebdavFactory getFactory() {
        return this.factory;
    }

    @Override
    protected List<WebdavProperty> internalGetAllProps() throws WebdavProtocolException {
        return Collections.emptyList();
    }

    @Override
    protected WebdavProperty internalGetProperty(String namespace, String name) throws WebdavProtocolException {
        return null;
    }

    @Override
    protected void internalPutProperty(WebdavProperty prop) throws WebdavProtocolException {
    }

    @Override
    protected void internalRemoveProperty(String namespace, String name) throws WebdavProtocolException {
    }

    @Override
    public void putBody(InputStream body, boolean guessSize) throws WebdavProtocolException {
        this.resource.putBody(body, guessSize);
    }

    @Override
    public void setCreationDate(Date date) throws WebdavProtocolException {
    }

    @Override
    public void create() throws WebdavProtocolException {
        this.delete();
        this.resource.create();
        this.transferLocks();
    }

    private void transferLocks() throws WebdavProtocolException {
        for (WebdavLock lock : this.getOwnLocks()) {
            ((OXWebdavResource)((Object)this.resource)).transferLock(lock);
        }
    }

    @Override
    public void delete() throws WebdavProtocolException {
        Context ctx = this.sessionHolder.getContext();
        Connection writeCon = null;
        Statement stmt = null;
        try {
            writeCon = this.provider.getWriteConnection(ctx);
            writeCon.setAutoCommit(false);
            stmt = writeCon.prepareStatement("DELETE FROM lock_null WHERE cid = ? and id = ?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, this.id);
            stmt.executeUpdate();
            writeCon.commit();
            this.exists = false;
            this.factory.invalidate(this.getUrl(), this.getId(), this.resource.isCollection() ? URLCache.Type.COLLECTION : URLCache.Type.RESOURCE);
        }
        catch (SQLException x) {
            DBUtils.rollback(writeCon);
            throw WebdavProtocolException.generalError(this.getUrl(), 500);
        }
        catch (OXException e) {
            DBUtils.rollback(writeCon);
            throw WebdavProtocolException.generalError(this.getUrl(), 500);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.debug("", (Throwable)e);
                }
            }
            DBUtils.autocommit(writeCon);
            if (writeCon != null) {
                this.provider.releaseWriteConnection(ctx, writeCon);
            }
        }
    }

    @Override
    public boolean exists() throws WebdavProtocolException {
        return this.exists;
    }

    @Override
    public InputStream getBody() throws WebdavProtocolException {
        return null;
    }

    @Override
    public String getContentType() throws WebdavProtocolException {
        return null;
    }

    @Override
    public Date getCreationDate() throws WebdavProtocolException {
        return null;
    }

    @Override
    public String getDisplayName() throws WebdavProtocolException {
        return null;
    }

    @Override
    public String getETag() throws WebdavProtocolException {
        return null;
    }

    @Override
    public String getLanguage() throws WebdavProtocolException {
        return null;
    }

    @Override
    public Date getLastModified() throws WebdavProtocolException {
        return null;
    }

    @Override
    public Long getLength() throws WebdavProtocolException {
        return null;
    }

    @Override
    public WebdavLock getLock(String token) throws WebdavProtocolException {
        WebdavLock lock = this.lockHelper.getLock(token);
        if (lock != null) {
            return lock;
        }
        return this.findParentLock(token);
    }

    @Override
    public List<WebdavLock> getLocks() throws WebdavProtocolException {
        List<WebdavLock> lockList = this.getOwnLocks();
        this.addParentLocks(lockList);
        return lockList;
    }

    @Override
    public WebdavLock getOwnLock(String token) throws WebdavProtocolException {
        return this.lockHelper.getLock(token);
    }

    @Override
    public List<WebdavLock> getOwnLocks() throws WebdavProtocolException {
        return this.lockHelper.getAllLocks();
    }

    @Override
    public String getSource() throws WebdavProtocolException {
        return null;
    }

    @Override
    public WebdavPath getUrl() {
        return this.resource.getUrl();
    }

    @Override
    public void lock(WebdavLock lock) throws WebdavProtocolException {
        try {
            this.dumpToDB();
            this.lockHelper.addLock(lock);
            this.lockHelper.dumpLocksToDB();
        }
        catch (Exception e) {
            throw WebdavProtocolException.generalError(this.getUrl(), 500);
        }
    }

    @Override
    public void save() throws WebdavProtocolException {
        throw WebdavProtocolException.generalError(this.getUrl(), 409);
    }

    @Override
    public void setContentType(String type) throws WebdavProtocolException {
    }

    @Override
    public void setDisplayName(String displayName) throws WebdavProtocolException {
    }

    @Override
    public void setLanguage(String language) throws WebdavProtocolException {
    }

    @Override
    public void setLength(Long length) throws WebdavProtocolException {
    }

    @Override
    public void setSource(String source) throws WebdavProtocolException {
    }

    @Override
    public boolean isLockNull() {
        return true;
    }

    @Override
    protected boolean isset(Protocol.Property p) {
        switch (p.getId()) {
            case 2: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void unlock(String token) throws WebdavProtocolException {
        this.lockHelper.removeLock(token);
        if (this.getOwnLocks().isEmpty()) {
            this.delete();
        }
    }

    @Override
    public WebdavMethod[] getOptions() {
        return OPTIONS;
    }

    private void dumpToDB() throws SQLException, OXException {
        if (this.exists) {
            return;
        }
        Context ctx = this.sessionHolder.getContext();
        Connection writeCon = null;
        Statement stmt = null;
        try {
            writeCon = this.provider.getWriteConnection(ctx);
            writeCon.setAutoCommit(false);
            int id = IDGenerator.getId(ctx, 137, writeCon);
            stmt = writeCon.prepareStatement("INSERT INTO lock_null (cid, id, url) VALUES (?,?,?)");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, id);
            stmt.setString(3, this.getUrl().toEscapedString());
            stmt.executeUpdate();
            this.setId(id);
            writeCon.commit();
        }
        catch (SQLException x) {
            DBUtils.rollback(writeCon);
            throw x;
        }
        catch (OXException e) {
            DBUtils.rollback(writeCon);
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DBUtils.autocommit(writeCon);
            if (writeCon != null) {
                this.provider.releaseWriteConnection(ctx, writeCon);
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getParentId() throws WebdavProtocolException {
        return ((OXWebdavResource)((Object)this.parent())).getId();
    }

    @Override
    public void removedParent() throws WebdavProtocolException {
    }

    public void setResource(AbstractResource res) {
        this.resource = res;
    }

    @Override
    protected void internalDelete() throws WebdavProtocolException {
    }

    @Override
    public List<WebdavResource> getChildren() throws WebdavProtocolException {
        return Collections.emptyList();
    }

    @Override
    public void transferLock(WebdavLock lock) {
    }
}

