/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.impl.FolderLock;
import com.openexchange.groupware.impl.FolderLockManager;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockHelper;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;

public class FolderLockHelper
extends LockHelper {
    private final FolderLockManager lockManager;
    private final SessionHolder sessionHolder;

    public FolderLockHelper(FolderLockManager lockManager, SessionHolder sessionHolder, WebdavPath url) {
        super(lockManager, sessionHolder, url);
        this.lockManager = lockManager;
        this.sessionHolder = sessionHolder;
    }

    @Override
    protected WebdavLock toWebdavLock(Lock lock) {
        if (lock instanceof FolderLock) {
            FolderLock folderLock = (FolderLock)lock;
            WebdavLock l = new WebdavLock();
            l.setDepth(folderLock.getDepth());
            l.setTimeout(folderLock.getTimeout());
            l.setToken("http://www.open-xchange.com/webdav/locks/" + folderLock.getId());
            l.setType(WebdavLock.Type.WRITE_LITERAL);
            l.setScope(folderLock.getScope().equals((Object)LockManager.Scope.EXCLUSIVE) ? WebdavLock.Scope.EXCLUSIVE_LITERAL : WebdavLock.Scope.SHARED_LITERAL);
            l.setOwner(lock.getOwnerDescription());
            l.setOwnerID(lock.getOwner());
            return l;
        }
        throw new IllegalArgumentException("Lock must be of type FolderLock");
    }

    @Override
    protected int saveLock(WebdavLock lock) throws OXException {
        ServerSession session = this.getSession();
        return this.lockManager.lock(this.id, lock.getTimeout() == -1L ? -1L : lock.getTimeout(), lock.getScope().equals((Object)WebdavLock.Scope.EXCLUSIVE_LITERAL) ? LockManager.Scope.EXCLUSIVE : LockManager.Scope.SHARED, LockManager.Type.WRITE, lock.getDepth(), lock.getOwner(), session.getContext(), UserStorage.getInstance().getUser(session.getUserId(), session.getContext()));
    }

    @Override
    protected void relock(WebdavLock lock) {
    }

    @Override
    protected Lock toLock(WebdavLock lock) {
        FolderLock l = new FolderLock();
        l.setId(Integer.valueOf(lock.getToken().substring(41)));
        l.setOwner(lock.getOwnerID());
        l.setOwnerDescription(lock.getOwner());
        l.setScope(lock.getScope().equals((Object)WebdavLock.Scope.EXCLUSIVE_LITERAL) ? LockManager.Scope.EXCLUSIVE : LockManager.Scope.SHARED);
        l.setType(LockManager.Type.WRITE);
        l.setDepth(lock.getDepth());
        l.setTimeout(lock.getTimeout());
        return l;
    }

    private ServerSession getSession() throws OXException {
        return ServerSessionAdapter.valueOf(this.sessionHolder.getSessionObject());
    }
}

