/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionConstants;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.EffectiveInfostorePermission;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurity;
import com.openexchange.groupware.infostore.utils.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.SetSwitch;
import com.openexchange.groupware.infostore.webdav.EntityLockHelper;
import com.openexchange.groupware.infostore.webdav.FolderCollection;
import com.openexchange.groupware.infostore.webdav.InfostoreLockNullResource;
import com.openexchange.groupware.infostore.webdav.InfostoreWebdavFactory;
import com.openexchange.groupware.infostore.webdav.LockHelper;
import com.openexchange.groupware.infostore.webdav.OXWebdavResource;
import com.openexchange.groupware.infostore.webdav.PropertyHelper;
import com.openexchange.groupware.infostore.webdav.URLCache;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Streams;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.tx.TransactionException;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.helpers.AbstractResource;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentMetadataResource
extends AbstractResource
implements OXWebdavResource,
OXExceptionConstants {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentMetadataResource.class);
    private final InfostoreWebdavFactory factory;
    private boolean exists;
    private int id;
    private DocumentMetadata metadata = new DocumentMetadataImpl();
    private final Set<Metadata> setMetadata = new HashSet<Metadata>();
    private final PropertyHelper propertyHelper;
    private WebdavPath url;
    private final SessionHolder sessionHolder;
    private final InfostoreFacade database;
    private final InfostoreSecurity security;
    private boolean loadedMetadata;
    private boolean existsInDB;
    private final LockHelper lockHelper;
    private boolean metadataChanged;

    public DocumentMetadataResource(WebdavPath url, InfostoreWebdavFactory factory) {
        this.factory = factory;
        this.url = url;
        this.sessionHolder = factory.getSessionHolder();
        this.lockHelper = new EntityLockHelper(factory.getInfoLockManager(), this.sessionHolder, url);
        this.database = factory.getDatabase();
        this.security = factory.getSecurity();
        this.propertyHelper = new PropertyHelper(factory.getInfoProperties(), this.sessionHolder, url);
    }

    public DocumentMetadataResource(WebdavPath url, DocumentMetadata docMeta, InfostoreWebdavFactory factory) {
        this.factory = factory;
        this.url = url;
        this.sessionHolder = factory.getSessionHolder();
        this.lockHelper = new EntityLockHelper(factory.getInfoLockManager(), this.sessionHolder, url);
        this.database = factory.getDatabase();
        this.security = factory.getSecurity();
        this.propertyHelper = new PropertyHelper(factory.getInfoProperties(), this.sessionHolder, url);
        this.metadata = docMeta;
        this.loadedMetadata = true;
        this.setId(this.metadata.getId());
        this.setExists(true);
    }

    @Override
    protected WebdavFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean hasBody() throws WebdavProtocolException {
        try {
            this.loadMetadata();
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500);
        }
        return this.metadata.getFileSize() > 0L;
    }

    @Override
    protected List<WebdavProperty> internalGetAllProps() throws WebdavProtocolException {
        try {
            return this.propertyHelper.getAllProps();
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500);
        }
    }

    @Override
    protected WebdavProperty internalGetProperty(String namespace, String name) throws WebdavProtocolException {
        try {
            return this.propertyHelper.getProperty(namespace, name);
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    @Override
    protected void internalPutProperty(WebdavProperty prop) {
        this.propertyHelper.putProperty(prop);
    }

    @Override
    protected void internalRemoveProperty(String namespace, String name) {
        this.propertyHelper.removeProperty(namespace, name);
    }

    @Override
    protected boolean isset(Protocol.Property p) {
        return !this.propertyHelper.isRemoved(new WebdavProperty(p.getNamespace(), p.getName()));
    }

    @Override
    public void setCreationDate(Date date) {
        this.metadata.setCreationDate(date);
        this.markChanged();
        this.markSet(Metadata.CREATION_DATE_LITERAL);
    }

    @Override
    public void create() throws WebdavProtocolException {
        if (this.exists) {
            throw WebdavProtocolException.Code.DIRECTORY_ALREADY_EXISTS.create(this.getUrl(), 405);
        }
        this.save();
        this.exists = true;
        try {
            this.factory.created(this);
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    @Override
    public void delete() throws WebdavProtocolException {
        if (this.exists) {
            try {
                this.lockHelper.deleteLocks();
                this.propertyHelper.deleteProperties();
                this.deleteMetadata();
                this.exists = false;
                this.factory.removed(this);
            }
            catch (OXException x) {
                if (Category.CATEGORY_PERMISSION_DENIED == x.getCategory()) {
                    throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 401, x, new Object[0]);
                }
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, x, new Object[0]);
            }
            catch (Exception x) {
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, x, new Object[0]);
            }
        }
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public InputStream getBody() throws WebdavProtocolException {
        ServerSession session = this.getSession();
        try {
            return this.database.getDocument(this.id, -1, session);
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
        catch (Exception e) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    @Override
    public String getContentType() throws WebdavProtocolException {
        this.loadMetadata();
        return this.metadata.getFileMIMEType();
    }

    @Override
    public Date getCreationDate() throws WebdavProtocolException {
        this.loadMetadata();
        return this.metadata.getCreationDate();
    }

    @Override
    public String getDisplayName() throws WebdavProtocolException {
        this.loadMetadata();
        return this.metadata.getFileName();
    }

    @Override
    public String getETag() {
        if (!this.exists && !this.existsInDB) {
            return null;
        }
        return String.format("http://www.open-xchange.com/webdav/etags/%d-%d-%d", this.getSession().getContext().getContextId(), this.metadata.getId(), this.metadata.getVersion());
    }

    @Override
    public String getLanguage() {
        return null;
    }

    @Override
    public Date getLastModified() throws WebdavProtocolException {
        this.loadMetadata();
        return this.metadata.getLastModified();
    }

    @Override
    public Long getLength() throws WebdavProtocolException {
        this.loadMetadata();
        return this.metadata.getFileSize();
    }

    @Override
    public WebdavLock getLock(String token) throws WebdavProtocolException {
        WebdavLock lock;
        try {
            lock = this.lockHelper.getLock(token);
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
        if (lock != null) {
            return lock;
        }
        return this.findParentLock(token);
    }

    @Override
    public List<WebdavLock> getLocks() throws WebdavProtocolException {
        List<WebdavLock> lockList = this.getOwnLocks();
        this.addParentLocks(lockList);
        return lockList;
    }

    @Override
    public WebdavLock getOwnLock(String token) throws WebdavProtocolException {
        try {
            return this.injectOwner(this.lockHelper.getLock(token));
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    @Override
    public List<WebdavLock> getOwnLocks() throws WebdavProtocolException {
        try {
            return this.injectOwner(this.lockHelper.getAllLocks());
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    private WebdavLock injectOwner(WebdavLock lock) throws WebdavProtocolException {
        if (lock.getOwner() == null || "".equals(lock.getOwner())) {
            this.loadMetadata();
            int userId = this.metadata.getModifiedBy();
            try {
                User user = UserStorage.getInstance().getUser(userId, this.getSession().getContext());
                String displayName = user.getDisplayName();
                if (displayName == null) {
                    displayName = user.getMail();
                }
                if (displayName == null) {
                    displayName = Integer.toString(userId);
                }
                lock.setOwner(displayName);
            }
            catch (OXException oXException) {
                // empty catch block
            }
        }
        return lock;
    }

    private List<WebdavLock> injectOwner(List<WebdavLock> allLocks) throws WebdavProtocolException {
        for (WebdavLock webdavLock : allLocks) {
            this.injectOwner(webdavLock);
        }
        return allLocks;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public WebdavPath getUrl() {
        return this.url;
    }

    @Override
    public void lock(WebdavLock lock) throws WebdavProtocolException {
        try {
            if (!this.exists) {
                new InfostoreLockNullResource(this, this.factory).lock(lock);
                this.factory.invalidate(this.getUrl(), this.getId(), URLCache.Type.RESOURCE);
                return;
            }
            this.lockHelper.addLock(lock);
            this.touch();
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    @Override
    public void unlock(String token) throws WebdavProtocolException {
        this.lockHelper.removeLock(token);
        try {
            this.lockHelper.dumpLocksToDB();
            this.touch();
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    @Override
    public void save() throws WebdavProtocolException {
        try {
            EffectiveInfostorePermission perm;
            this.dumpMetadataToDB();
            if (this.propertyHelper.mustWrite() && !(perm = this.security.getInfostorePermission(this.getSession(), this.getId())).canWriteObject()) {
                throw WebdavProtocolException.Code.NO_WRITE_PERMISSION.create(this.getUrl(), 401);
            }
            this.propertyHelper.dumpPropertiesToDB();
            this.lockHelper.dumpLocksToDB();
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
        catch (Exception e) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    @Override
    public void setContentType(String type) {
        this.metadata.setFileMIMEType(type);
        this.markChanged();
        this.markSet(Metadata.FILE_MIMETYPE_LITERAL);
    }

    @Override
    public void setDisplayName(String displayName) {
        this.metadata.setFileName(displayName);
        this.markChanged();
        this.markSet(Metadata.FILENAME_LITERAL);
    }

    @Override
    public void setLength(Long length) {
        this.metadata.setFileSize(length);
        this.markChanged();
        this.markSet(Metadata.FILE_SIZE_LITERAL);
    }

    @Override
    public void setSource(String source) {
    }

    @Override
    public void setLanguage(String language) {
    }

    public void setId(int id) {
        this.id = id;
        this.propertyHelper.setId(id);
        this.lockHelper.setId(id);
    }

    public void setExists(boolean b) {
        this.exists = b;
    }

    @Override
    public WebdavResource move(WebdavPath dest, boolean noroot, boolean overwrite) throws WebdavProtocolException {
        FolderCollection coll;
        WebdavResource res;
        try {
            res = this.factory.resolveResource(dest);
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
        if (res.exists()) {
            if (!overwrite) {
                throw WebdavProtocolException.Code.FILE_ALREADY_EXISTS.create(this.getUrl(), 412, dest);
            }
            res.delete();
        }
        WebdavPath parent = dest.parent();
        String name = dest.name();
        try {
            coll = (FolderCollection)this.factory.resolveCollection(parent);
            if (!coll.exists()) {
                throw WebdavProtocolException.Code.FOLDER_NOT_FOUND.create(this.getUrl(), 409, parent);
            }
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
        this.loadMetadata();
        this.metadata.setTitle(name);
        this.metadata.setFileName(name);
        this.metadata.setFolderId(coll.getId());
        this.metadataChanged = true;
        this.setMetadata.add(Metadata.TITLE_LITERAL);
        this.setMetadata.add(Metadata.FILENAME_LITERAL);
        this.setMetadata.add(Metadata.FOLDER_ID_LITERAL);
        this.factory.invalidate(this.url, this.id, URLCache.Type.RESOURCE);
        this.factory.invalidate(dest, this.id, URLCache.Type.RESOURCE);
        this.url = dest;
        this.save();
        try {
            this.lockHelper.deleteLocks();
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
        return this;
    }

    @Override
    public WebdavResource copy(WebdavPath dest, boolean noroot, boolean overwrite) throws WebdavProtocolException {
        try {
            WebdavPath parent = dest.parent();
            String name = dest.name();
            FolderCollection coll = (FolderCollection)this.factory.resolveCollection(parent);
            if (!coll.exists()) {
                throw WebdavProtocolException.Code.FOLDER_NOT_FOUND.create(this.getUrl(), 409, parent);
            }
            DocumentMetadataResource copy = (DocumentMetadataResource)this.factory.resolveResource(dest);
            if (copy.exists()) {
                if (!overwrite) {
                    throw WebdavProtocolException.Code.FILE_ALREADY_EXISTS.create(this.getUrl(), 412, dest);
                }
                copy.delete();
            }
            this.copyMetadata(copy);
            this.initDest(copy, name, coll.getId());
            copy.url = dest;
            this.copyProperties(copy);
            this.copyBody(copy);
            copy.create();
            this.factory.invalidate(dest, copy.getId(), URLCache.Type.RESOURCE);
            try {
                this.lockHelper.deleteLocks();
            }
            catch (OXException e) {
                if (e instanceof WebdavProtocolException) {
                    throw (WebdavProtocolException)e;
                }
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
            }
            return copy;
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    private void initDest(DocumentMetadataResource copy, String name, int parentId) {
        copy.metadata.setTitle(name);
        copy.metadata.setFileName(name);
        copy.metadata.setFolderId(parentId);
    }

    private void copyMetadata(DocumentMetadataResource copy) throws WebdavProtocolException {
        this.loadMetadata();
        copy.metadata = new DocumentMetadataImpl(this.metadata);
        copy.metadata.setFilestoreLocation(null);
        copy.metadata.setId(-1);
        copy.metadataChanged = true;
        copy.setMetadata.addAll(Metadata.VALUES);
    }

    private void copyProperties(DocumentMetadataResource copy) throws WebdavProtocolException {
        for (WebdavProperty prop : this.internalGetAllProps()) {
            copy.putProperty(prop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBody(DocumentMetadataResource copy) throws WebdavProtocolException {
        InputStream in = this.getBody();
        if (in != null) {
            try {
                copy.putBody(in);
            }
            finally {
                Streams.close((Closeable)in);
            }
        }
    }

    private void loadMetadata() throws WebdavProtocolException {
        if (!this.exists) {
            return;
        }
        if (this.loadedMetadata) {
            return;
        }
        this.loadedMetadata = true;
        HashSet<Metadata> toLoad = new HashSet<Metadata>(Metadata.VALUES);
        toLoad.removeAll(this.setMetadata);
        ServerSession session = this.getSession();
        try {
            DocumentMetadata metadata = this.database.getDocumentMetadata(this.id, -1, session);
            SetSwitch set = new SetSwitch(this.metadata);
            GetSwitch get = new GetSwitch(metadata);
            for (Metadata m : toLoad) {
                set.setValue(m.doSwitch(get));
                m.doSwitch(set);
            }
        }
        catch (OXException x) {
            if (CATEGORY_PERMISSION_DENIED == x.getCategory()) {
                this.metadata.setId(this.getId());
                this.metadata.setFolderId(((OXWebdavResource)((Object)this.parent())).getId());
                this.initNameAndTitle();
            }
            if (x instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)x;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, x, new Object[0]);
        }
        catch (Exception x) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, x, new Object[0]);
        }
    }

    private void markSet(Metadata metadata) {
        this.setMetadata.add(metadata);
    }

    private void markChanged() {
        this.metadataChanged = true;
    }

    @Override
    public void putBody(InputStream body, boolean guessSize) throws WebdavProtocolException {
        block25: {
            try {
                if (!this.exists && !this.existsInDB) {
                    try {
                        this.dumpMetadataToDB(body, guessSize);
                        break block25;
                    }
                    catch (WebdavProtocolException x) {
                        throw x;
                    }
                    catch (OXException x) {
                        if (CATEGORY_PERMISSION_DENIED == x.getCategory()) {
                            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.url, 401);
                        }
                        throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.url, 500, x, new Object[0]);
                    }
                    catch (Exception x) {
                        throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.url, 500, x, new Object[0]);
                    }
                }
                ServerSession session = this.getSession();
                try {
                    this.database.startTransaction();
                    this.loadMetadata();
                    if (guessSize) {
                        this.metadata.setFileSize(0L);
                    }
                    this.database.saveDocument(this.metadata, body, Long.MAX_VALUE, session);
                    this.database.commit();
                }
                catch (Exception x) {
                    try {
                        this.database.rollback();
                    }
                    catch (OXException e) {
                        LOG.error("Couldn't rollback transaction. Run the recovery tool.");
                    }
                    if (x instanceof OXException) {
                        OXException iStoreException = (OXException)((Object)x);
                        if (EnumComponent.INFOSTORE.getAbbreviation().equals(iStoreException.getPrefix())) {
                            if (415 == iStoreException.getCode()) {
                                throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 423);
                            }
                            if (CATEGORY_PERMISSION_DENIED == iStoreException.getCategory()) {
                                throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.url, 401);
                            }
                        }
                    }
                    throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.url, 500, x, new Object[0]);
                }
                finally {
                    try {
                        this.database.finish();
                    }
                    catch (OXException e) {
                        LOG.error("Couldn't finish transaction: ", (Throwable)e);
                    }
                }
            }
            catch (OXException e) {
                if (e instanceof WebdavProtocolException) {
                    throw (WebdavProtocolException)e;
                }
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
            }
        }
    }

    private void dumpMetadataToDB(InputStream fileData, boolean guessSize) throws WebdavProtocolException, OXException, TransactionException {
        if ((this.exists || this.existsInDB) && !this.metadataChanged) {
            return;
        }
        FolderCollection parent = null;
        try {
            parent = (FolderCollection)this.parent();
            if (!parent.exists()) {
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 409);
            }
            if (parent.isRoot()) {
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 401);
            }
            EffectivePermission permission = parent.getEffectivePermission();
            if (!(null == permission || permission.canCreateObjects() && permission.canWriteOwnObjects())) {
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 401);
            }
        }
        catch (ClassCastException x) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 409);
        }
        this.initNameAndTitle();
        if (fileData != null && guessSize) {
            this.metadata.setFileSize(0L);
        }
        ServerSession session = this.getSession();
        this.metadata.setFolderId(parent.getId());
        if (!this.exists && !this.existsInDB) {
            this.metadata.setVersion(-1);
            this.metadata.setId(-1);
            this.database.startTransaction();
            try {
                if (fileData == null) {
                    this.database.saveDocumentMetadata(this.metadata, -1L, session);
                } else {
                    this.database.saveDocument(this.metadata, fileData, -1L, session);
                }
                this.database.commit();
                this.setId(this.metadata.getId());
            }
            catch (OXException x) {
                try {
                    this.database.rollback();
                }
                catch (OXException x2) {
                    LOG.error("Couldn't roll back: ", (Throwable)x2);
                }
                throw x;
            }
            finally {
                this.database.finish();
            }
        }
        this.database.startTransaction();
        if (this.setMetadata.contains(Metadata.FILENAME_LITERAL)) {
            this.metadata.setTitle(this.metadata.getFileName());
            this.setMetadata.add(Metadata.TITLE_LITERAL);
        }
        try {
            this.database.saveDocumentMetadata(this.metadata, Long.MAX_VALUE, this.setMetadata.toArray(new Metadata[this.setMetadata.size()]), session);
            this.database.commit();
        }
        catch (OXException x) {
            try {
                this.database.rollback();
            }
            catch (OXException x2) {
                LOG.error("Can't roll back", (Throwable)x2);
            }
            throw x;
        }
        finally {
            this.database.finish();
        }
        this.existsInDB = true;
        this.setMetadata.clear();
        this.metadataChanged = false;
    }

    private void touch() throws WebdavProtocolException {
        try {
            if (!this.existsInDB && !this.exists) {
                return;
            }
            this.database.touch(this.getId(), this.getSession());
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    private void initNameAndTitle() {
        if (this.metadata.getFileName() == null || this.metadata.getFileName().trim().length() == 0) {
            this.metadata.setFileName(this.url.name());
        }
        this.metadata.setTitle(this.metadata.getFileName());
    }

    private void dumpMetadataToDB() throws WebdavProtocolException, OXException, TransactionException {
        this.dumpMetadataToDB(null, false);
    }

    private void deleteMetadata() throws OXException {
        ServerSession session = this.getSession();
        this.database.startTransaction();
        try {
            DocumentMetadata document = this.database.getDocumentMetadata(this.id, -1, session);
            List<FileStorageFileAccess.IDTuple> nd = this.database.removeDocument(Collections.singletonList(new FileStorageFileAccess.IDTuple(Long.toString(document.getFolderId()), Integer.toString(document.getId()))), Long.MAX_VALUE, session);
            if (nd.size() > 0) {
                this.database.rollback();
                throw InfostoreExceptionCodes.DELETE_FAILED.create(Integer.parseInt(nd.get(0).getId()));
            }
            this.database.commit();
        }
        catch (OXException x) {
            this.database.rollback();
            throw x;
        }
        finally {
            this.database.finish();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getParentId() throws WebdavProtocolException {
        if (this.metadata == null) {
            this.loadMetadata();
        }
        return (int)this.metadata.getFolderId();
    }

    @Override
    public void removedParent() throws WebdavProtocolException {
        try {
            this.exists = false;
            this.factory.removed(this);
        }
        catch (OXException e) {
            if (e instanceof WebdavProtocolException) {
                throw (WebdavProtocolException)e;
            }
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    @Override
    public void transferLock(WebdavLock lock) throws WebdavProtocolException {
        try {
            this.lockHelper.transferLock(lock);
        }
        catch (OXException e) {
            throw WebdavProtocolException.Code.GENERAL_ERROR.create(this.getUrl(), 500, e, new Object[0]);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " :" + this.id;
    }

    private ServerSession getSession() {
        return ServerSessionAdapter.valueOf(this.sessionHolder.getSessionObject(), this.sessionHolder.getContext());
    }

    @Override
    protected AbstractResource.SpecialSetSwitch getSetSwitch(String value) {
        return new InfostoreSetSwitch(value);
    }

    private class InfostoreSetSwitch
    extends AbstractResource.SpecialSetSwitch {
        public InfostoreSetSwitch(String value) {
            super(DocumentMetadataResource.this, value);
        }

        @Override
        public Object lastModified() throws WebdavProtocolException {
            try {
                DocumentMetadataResource.this.loadMetadata();
                long parsed = Long.parseLong(this.value);
                DocumentMetadataResource.this.metadata.setLastModified(new Date(parsed));
                DocumentMetadataResource.this.markChanged();
                DocumentMetadataResource.this.markSet(Metadata.LAST_MODIFIED_LITERAL);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Boolean.TRUE;
        }
    }
}

